/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.media.frontend.jersey;

import com.google.gson.Gson;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.glassfish.jersey.server.JSONP;
import org.mycore.datamodel.metadata.MCRObjectID;
import org.mycore.frontend.jersey.MCRJerseyUtil;
import org.mycore.media.video.MCRMediaSource;
import org.mycore.media.video.MCRMediaSourceProvider;

@Path(value="jwplayer")
public class MCRJWPlayerResource {
    @Context
    private HttpServletRequest request;

    @GET
    @Path(value="{derivateId}/{path: .+}/sources.js")
    @Produces(value={"application/javascript"})
    @JSONP(callback="callback", queryParam="callback")
    public String getSourcesAsJSONP(@PathParam(value="derivateId") String derivateId, @PathParam(value="path") String path) throws URISyntaxException, IOException {
        return this.getSources(derivateId, path);
    }

    @GET
    @Path(value="{derivateId}/{path: .+}/sources.json")
    @Produces(value={"application/javascript"})
    public String getSources(@PathParam(value="derivateId") String derivateId, @PathParam(value="path") String path) throws URISyntaxException, IOException {
        MCRObjectID derivate = MCRJerseyUtil.getID((String)derivateId);
        MCRJerseyUtil.checkDerivateReadPermission((MCRObjectID)derivate);
        try {
            MCRMediaSourceProvider formatter = new MCRMediaSourceProvider(derivateId, path, Optional.ofNullable(this.request.getHeader("User-Agent")), () -> (String[])Arrays.stream(Optional.ofNullable(this.request.getQueryString()).orElse("").split("&")).filter(p -> !p.startsWith("callback=")).toArray(String[]::new));
            return this.toJson(formatter.getSources());
        }
        catch (NoSuchFileException e) {
            LogManager.getLogger().warn("Could not find video file.", (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    private String toJson(List<MCRMediaSource> sources) {
        return new Gson().toJson(sources.stream().map(s -> new Source(s.getUri(), s.getType().getSimpleType())).toArray(Source[]::new));
    }

    private static class Source {
        private String file;
        private String type;

        Source(String file, String type) {
            LogManager.getLogger().info("file : {}", (Object)file);
            this.file = file;
            this.type = type;
        }
    }
}

