/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.media.frontend.jersey;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mycore.access.MCRAccessManager;
import org.mycore.common.config.MCRConfiguration2;
import org.mycore.datamodel.metadata.MCRMetadataManager;
import org.mycore.datamodel.metadata.MCRObjectID;
import org.mycore.datamodel.niofs.MCRPath;
import org.mycore.frontend.jersey.MCRJerseyUtil;

@Path(value="thumbnail")
public class MCRThumbnailResource {
    @Context
    private Request request;

    @GET
    @Path(value="{documentId}/{size}.{ext}")
    @Produces(value={"image/png", "image/jpeg"})
    public Response getThumbnailFromDocument(@PathParam(value="documentId") String documentId, @PathParam(value="size") int size, @PathParam(value="ext") String ext) {
        return this.getThumbnail(documentId, size, ext);
    }

    @GET
    @Path(value="{documentId}.{ext}")
    @Produces(value={"image/png", "image/jpeg"})
    public Response getThumbnailFromDocument(@PathParam(value="documentId") String documentId, @PathParam(value="ext") String ext) {
        int defaultSize = (Integer)MCRConfiguration2.getOrThrow((String)"MCR.Media.Thumbnail.DefaultSize", Integer::parseInt);
        return this.getThumbnail(documentId, defaultSize, ext);
    }

    private Response getThumbnail(String documentId, int size, String ext) {
        List derivateIds = MCRMetadataManager.getDerivateIds((MCRObjectID)MCRJerseyUtil.getID((String)documentId), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        for (MCRObjectID derivateId : derivateIds) {
            String nameOfMainFile;
            if (!MCRAccessManager.checkPermissionForReadingDerivate((String)derivateId.toString()) || (nameOfMainFile = MCRMetadataManager.retrieveMCRDerivate((MCRObjectID)derivateId).getDerivate().getInternals().getMainDoc()) == null || nameOfMainFile.equals("")) continue;
            MCRPath mainFile = MCRPath.getPath((String)derivateId.toString(), (String)("/" + nameOfMainFile));
            try {
                FileTime lastModified = Files.getLastModifiedTime((java.nio.file.Path)mainFile, new LinkOption[0]);
                Date lastModifiedDate = new Date(lastModified.toMillis());
                Response.ResponseBuilder resp = this.request.evaluatePreconditions(lastModifiedDate);
                if (resp != null) {
                    return resp.build();
                }
                String mimeType = Files.probeContentType((java.nio.file.Path)mainFile);
                List generators = ((Stream)MCRConfiguration2.getOrThrow((String)"MCR.Media.Thumbnail.Generators", MCRConfiguration2::splitValue)).map(MCRConfiguration2::instantiateClass).filter(thumbnailGenerator -> thumbnailGenerator.matchesFileType(mimeType, mainFile)).collect(Collectors.toList());
                Optional<BufferedImage> thumbnail = generators.stream().map(thumbnailGenerator -> {
                    try {
                        return thumbnailGenerator.getThumbnail(mainFile, size);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }).filter(Optional::isPresent).map(Optional::get).findFirst();
                if (!thumbnail.isPresent()) continue;
                CacheControl cc = new CacheControl();
                cc.setMaxAge((int)TimeUnit.DAYS.toSeconds(1L));
                String type = "image/png";
                if ("jpg".equals(ext) || "jpeg".equals(ext)) {
                    type = "image/jpeg";
                }
                return Response.ok((Object)thumbnail.get()).cacheControl(cc).lastModified(lastModifiedDate).type(type).build();
            }
            catch (IOException | RuntimeException e) {
                throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

