/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.media.services;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.mycore.datamodel.niofs.MCRPath;
import org.mycore.media.services.MCRThumbnailGenerator;
import org.mycore.media.services.MCRThumbnailUtils;

public class MCRPdfThumbnailGenerator
implements MCRThumbnailGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern MATCHING_MIMETYPE = Pattern.compile("^application/pdf");

    @Override
    public boolean matchesFileType(String mimeType, MCRPath path) {
        return MATCHING_MIMETYPE.matcher(mimeType).matches();
    }

    @Override
    public Optional<BufferedImage> getThumbnail(MCRPath path, int size) throws IOException {
        try (InputStream fileIS = Files.newInputStream((Path)path, new OpenOption[0]);){
            Optional<BufferedImage> optional;
            block17: {
                BufferedImage pdfRender;
                PDDocument pdf;
                block15: {
                    Optional<BufferedImage> optional2;
                    block16: {
                        pdf = PDDocument.load((InputStream)fileIS);
                        try {
                            int imageType;
                            PDPage page = this.resolveOpenActionPage(pdf);
                            float pdfWidth = page.getCropBox().getWidth();
                            float pdfHeight = page.getCropBox().getHeight();
                            int newWidth = pdfWidth > pdfHeight ? (int)Math.ceil((float)size * pdfWidth / pdfHeight) : size;
                            float scale = (float)newWidth / pdfWidth;
                            PDFRenderer pdfRenderer = new PDFRenderer(pdf);
                            int pageIndex = pdf.getPages().indexOf(page);
                            if (pageIndex == -1) {
                                LOGGER.warn("Could not resolve initial page, using first page.");
                                pageIndex = 0;
                            }
                            if ((imageType = MCRThumbnailUtils.getImageType(pdfRender = pdfRenderer.renderImage(pageIndex, scale))) != 12 && imageType != 10) break block15;
                            BufferedImage thumbnail = new BufferedImage(pdfRender.getWidth(), pdfRender.getHeight(), imageType);
                            Graphics g = thumbnail.getGraphics();
                            g.drawImage(pdfRender, 0, 0, null);
                            g.dispose();
                            optional2 = Optional.of(thumbnail);
                            if (pdf == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (pdf != null) {
                                try {
                                    pdf.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        pdf.close();
                    }
                    return optional2;
                }
                optional = Optional.of(pdfRender);
                if (pdf == null) break block17;
                pdf.close();
            }
            return optional;
        }
    }

    private PDPage resolveOpenActionPage(PDDocument pdf) throws IOException {
        PDDestination destination;
        PDDestinationOrAction openAction = pdf.getDocumentCatalog().getOpenAction();
        if (openAction instanceof PDActionGoTo && (destination = ((PDActionGoTo)openAction).getDestination()) instanceof PDPageDestination) {
            openAction = destination;
        }
        if (openAction instanceof PDPageDestination) {
            PDPageDestination namedDestination = (PDPageDestination)openAction;
            PDPage pdPage = namedDestination.getPage();
            if (pdPage != null) {
                return pdPage;
            }
            int pageNumber = namedDestination.getPageNumber();
            if (pageNumber != -1) {
                return pdf.getPage(pageNumber);
            }
        }
        return pdf.getPage(0);
    }
}

