/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.media.services;

import java.awt.image.BufferedImage;

public class MCRThumbnailUtils {
    public static int getImageType(BufferedImage image) {
        int colorType = 12;
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int colorTypeTemp = MCRThumbnailUtils.getColorType(image.getRGB(x, y));
                if (colorTypeTemp == 6) {
                    return 6;
                }
                colorType = colorTypeTemp < colorType ? colorTypeTemp : colorType;
            }
        }
        return colorType;
    }

    public static int getColorType(int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        if (alpha < 255) {
            return 6;
        }
        if (red == green && green == blue) {
            if (red == 255 || red == 0) {
                return 12;
            }
            return 10;
        }
        return 5;
    }
}

