/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.media.video;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.mycore.common.MCRSessionMgr;
import org.mycore.common.config.MCRConfiguration2;
import org.mycore.datamodel.metadata.MCRObjectID;
import org.mycore.datamodel.niofs.MCRAbstractFileStore;
import org.mycore.datamodel.niofs.MCRPath;
import org.mycore.frontend.filter.MCRSecureTokenV2FilterConfig;
import org.mycore.frontend.support.MCRSecureTokenV2;
import org.mycore.media.MCRMediaSourceType;
import org.mycore.media.video.MCRMediaSource;

public class MCRMediaSourceProvider {
    private static Optional<String> wowzaBaseURL = MCRConfiguration2.getString((String)"MCR.Media.Wowza.BaseURL");
    private static Optional<String> wowzaRTMPBaseURL = MCRConfiguration2.getString((String)"MCR.Media.Wowza.RTMPBaseURL");
    private static String wowzaHashParameter = MCRConfiguration2.getString((String)"MCR.Media.Wowza.HashParameter").orElse("wowzatokenhash");
    private Optional<MCRSecureTokenV2> wowzaToken;
    private ArrayList<MCRMediaSource> sources;

    public MCRMediaSourceProvider(String derivateId, String path, Optional<String> userAgent, Supplier<String[]> parameterSupplier) throws IOException, URISyntaxException {
        try {
            this.wowzaToken = wowzaBaseURL.map(w -> new MCRSecureTokenV2(MCRConfiguration2.getStringOrThrow((String)"MCR.Media.Wowza.ContentPathPrefix") + MCRMediaSourceProvider.getContentPath(derivateId, path), MCRSessionMgr.getCurrentSession().getCurrentIP(), MCRConfiguration2.getStringOrThrow((String)"MCR.Media.Wowza.SharedSecred"), (String[])parameterSupplier.get()));
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof URISyntaxException) {
                    throw (URISyntaxException)cause;
                }
            }
            throw e;
        }
        ArrayList<MCRMediaSource> mediaSources = new ArrayList<MCRMediaSource>(4);
        this.getDashStream().map(s -> new MCRMediaSource((String)s, MCRMediaSourceType.dash_stream)).ifPresent(mediaSources::add);
        userAgent.filter(MCRMediaSourceProvider::mayContainHLSStream).ifPresent(f -> this.getHLSStream().map(s -> new MCRMediaSource((String)s, MCRMediaSourceType.hls_stream)).ifPresent(mediaSources::add));
        this.getRTMPStream().map(s -> new MCRMediaSource((String)s, MCRMediaSourceType.rtmp_stream)).ifPresent(mediaSources::add);
        mediaSources.add(new MCRMediaSource(this.getPseudoStream(MCRObjectID.getInstance((String)derivateId), path), MCRMediaSourceType.mp4));
        this.sources = mediaSources;
    }

    public static void updateWowzaSettings(String propertyName, Optional<String> oldValue, Optional<String> newValue) {
        switch (propertyName) {
            case "MCR.Media.Wowza.BaseURL": {
                wowzaBaseURL = newValue;
                break;
            }
            case "MCR.Media.Wowza.RTMPBaseURL": {
                wowzaRTMPBaseURL = newValue;
                break;
            }
            case "MCR.Media.Wowza.HashParameter": {
                wowzaHashParameter = newValue.orElse("wowzatokenhash");
                break;
            }
        }
    }

    public List<MCRMediaSource> getSources() {
        return Collections.unmodifiableList(this.sources);
    }

    private Optional<String> toURL(MCRSecureTokenV2 token, Optional<String> baseURL, String suffix, String hashParameterName) {
        return baseURL.map(b -> {
            try {
                return token.toURI(b, suffix, hashParameterName).toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Optional<String> getDashStream() {
        return this.wowzaToken.flatMap(w -> this.toURL((MCRSecureTokenV2)w, wowzaBaseURL, "/manifest.mpd", wowzaHashParameter));
    }

    private Optional<String> getHLSStream() {
        return this.wowzaToken.flatMap(w -> this.toURL((MCRSecureTokenV2)w, wowzaBaseURL, "/playlist.m3u8", wowzaHashParameter));
    }

    private Optional<String> getRTMPStream() {
        return this.wowzaToken.flatMap(w -> this.toURL((MCRSecureTokenV2)w, wowzaRTMPBaseURL, "", wowzaHashParameter));
    }

    private String getPseudoStream(MCRObjectID derivate, String path) {
        return MCRSecureTokenV2FilterConfig.getFileNodeServletSecured((MCRObjectID)derivate, (String)path);
    }

    private static String getContentPath(String derivateId, String path) {
        try {
            MCRPath mcrPath = MCRPath.getPath((String)derivateId, (String)path);
            MCRAbstractFileStore fileStore = (MCRAbstractFileStore)Files.getFileStore((Path)mcrPath);
            Path absolutePath = fileStore.getPhysicalPath(mcrPath);
            Path relativePath = fileStore.getBaseDirectory().relativize(absolutePath);
            LogManager.getLogger().info("{} -> {} -> {}", (Object)mcrPath, (Object)absolutePath, (Object)relativePath);
            return relativePath.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean mayContainHLSStream(String userAgent) {
        return !userAgent.contains("Android") || !userAgent.contains("Gecko");
    }

    static {
        MCRConfiguration2.addPropertyChangeEventLister(p -> p.startsWith("MCR.Media.Wowza"), MCRMediaSourceProvider::updateWowzaSettings);
    }
}

