/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wcms2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.mycore.common.config.MCRConfiguration2;
import org.mycore.wcms2.datamodel.MCRNavigation;
import org.w3c.dom.Node;

public abstract class MCRWCMSUtil {
    public static MCRNavigation load(org.w3c.dom.Document doc) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{MCRNavigation.class});
        Unmarshaller m = jc.createUnmarshaller();
        Object navigation = m.unmarshal((Node)doc);
        if (navigation instanceof MCRNavigation) {
            return (MCRNavigation)navigation;
        }
        return null;
    }

    public static MCRNavigation load(File navigationFile) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{MCRNavigation.class});
        Unmarshaller m = jc.createUnmarshaller();
        Object navigation = m.unmarshal(navigationFile);
        if (navigation instanceof MCRNavigation) {
            return (MCRNavigation)navigation;
        }
        return null;
    }

    public static void save(MCRNavigation navigation, OutputStream out) throws JAXBException, IOException, JDOMException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{MCRNavigation.class});
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(65536);
        m.marshal((Object)navigation, (OutputStream)bout);
        byte[] xml = bout.toByteArray();
        if (MCRWCMSUtil.saveInOldFormat()) {
            xml = MCRWCMSUtil.convertToOldFormat(xml);
        }
        out.write(xml);
    }

    private static byte[] convertToOldFormat(byte[] xml) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((InputStream)new ByteArrayInputStream(xml));
        Element rootElement = doc.getRootElement();
        rootElement.setAttribute("href", rootElement.getName());
        List children = rootElement.getChildren();
        for (Element menu : children) {
            String id = menu.getAttributeValue("id");
            menu.setName(id);
            menu.setAttribute("href", id);
            menu.removeAttribute("id");
        }
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        ByteArrayOutputStream bout = new ByteArrayOutputStream(xml.length);
        out.output(doc, (OutputStream)bout);
        return bout.toByteArray();
    }

    private static boolean saveInOldFormat() {
        return (Boolean)MCRConfiguration2.getOrThrow((String)"MCR.NavigationFile.SaveInOldFormat", Boolean::parseBoolean);
    }
}

