/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wcms2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mycore.common.MCRException;
import org.mycore.common.config.MCRConfiguration2;
import org.mycore.common.events.MCRStartupHandler;

public class MCRWebPagesSynchronizer
implements MCRStartupHandler.AutoExecutable {
    private static Logger LOGGER = LogManager.getLogger(MCRWebPagesSynchronizer.class);
    private static final int FAT_PRECISION = 2000;
    private static final long DEFAULT_COPY_BUFFER_SIZE = 0x1000000L;
    private static ServletContext SERVLET_CONTEXT = null;

    public String getName() {
        return "Webpages synchronizer";
    }

    public int getPriority() {
        return 0;
    }

    public void startUp(ServletContext servletContext) {
        if (servletContext != null) {
            SERVLET_CONTEXT = servletContext;
            File wcmsDataDir = null;
            File webappBasePath = null;
            try {
                webappBasePath = MCRWebPagesSynchronizer.getWebAppBaseDir();
                LOGGER.info("WebAppBasePath={}", (Object)webappBasePath.getAbsolutePath());
                wcmsDataDir = MCRWebPagesSynchronizer.getWCMSDataDir();
                if (!wcmsDataDir.isDirectory()) {
                    LOGGER.info("{} does not exist or is not a directory. Skipping synchronization.", (Object)wcmsDataDir.getAbsolutePath());
                    return;
                }
                MCRWebPagesSynchronizer.synchronize(wcmsDataDir, webappBasePath);
            }
            catch (IOException e) {
                throw new MCRException("Error while synchronizing " + wcmsDataDir + " to " + webappBasePath, (Throwable)e);
            }
        }
    }

    public static File getWCMSDataDir() {
        return new File(MCRConfiguration2.getStringOrThrow((String)"MCR.WCMS2.DataDir"));
    }

    public static File getWebAppBaseDir() throws IOException {
        if (SERVLET_CONTEXT == null) {
            throw new IOException("ServletContext is not initialized.");
        }
        String realPath = SERVLET_CONTEXT.getRealPath("/");
        if (realPath == null) {
            throw new IOException("Could not get webapp base path.");
        }
        return new File(realPath);
    }

    public static OutputStream getOutputStream(String path) throws IOException {
        String cleanPath = path.startsWith("/") ? path.substring(1) : path;
        File wcmsDataDir = MCRWebPagesSynchronizer.getWCMSDataDir();
        File webappBaseDir = MCRWebPagesSynchronizer.getWebAppBaseDir();
        File webappTarget = new File(webappBaseDir, cleanPath);
        if (!webappTarget.toPath().startsWith(webappBaseDir.toPath())) {
            throw new IOException(String.format(Locale.ROOT, "Cannot write %s outside the web application: %s", webappTarget, webappBaseDir));
        }
        File wcmsDataDirTarget = new File(wcmsDataDir, cleanPath);
        MCRWebPagesSynchronizer.createDirectoryIfNeeded(webappTarget);
        MCRWebPagesSynchronizer.createDirectoryIfNeeded(wcmsDataDirTarget);
        LOGGER.info(String.format(Locale.ROOT, "Writing content to %s and to %s.", webappTarget, wcmsDataDirTarget));
        return new TeeOutputStream((OutputStream)new FileOutputStream(wcmsDataDirTarget), (OutputStream)new FileOutputStream(webappTarget));
    }

    private static void createDirectoryIfNeeded(File targetFile) throws IOException {
        File targetDirectory = targetFile.getParentFile();
        if (!targetDirectory.isDirectory() && !targetDirectory.mkdirs()) {
            throw new IOException(String.format(Locale.ROOT, "Could not create directory: %s", targetDirectory));
        }
    }

    public static URL getURL(String path) throws MalformedURLException {
        String cleanPath = path.startsWith("/") ? path : String.format(Locale.ROOT, "/%s", path);
        return SERVLET_CONTEXT.getResource(cleanPath);
    }

    public InputStream getInputStream(String path) {
        String cleanPath = path.startsWith("/") ? path : String.format(Locale.ROOT, "/%s", path);
        return SERVLET_CONTEXT.getResourceAsStream(cleanPath);
    }

    private static void synchronize(File wcmsDataDir, File webappBasePath) throws IOException {
        MCRWebPagesSynchronizer.synchronize(wcmsDataDir, webappBasePath, 0x1000000L);
    }

    private static void synchronize(File source, File destination, long chuckSize) throws IOException {
        long newChuckSize = chuckSize;
        if (newChuckSize <= 0L) {
            LOGGER.error("Chunk size must be positive: using default value.");
            newChuckSize = 0x1000000L;
        }
        if (source.isDirectory()) {
            File[] sources;
            if (!destination.exists()) {
                if (!destination.mkdirs()) {
                    throw new IOException("Could not create path " + destination);
                }
            } else if (!destination.isDirectory()) {
                throw new IOException("Source and Destination not of the same type:" + source.getCanonicalPath() + " , " + destination.getCanonicalPath());
            }
            for (File srcFile : sources = source.listFiles()) {
                File destFile = new File(destination, srcFile.getName());
                MCRWebPagesSynchronizer.synchronize(srcFile, destFile, newChuckSize);
            }
        } else {
            if (destination.exists() && destination.isDirectory()) {
                MCRWebPagesSynchronizer.delete(destination);
            }
            if (destination.exists()) {
                long sts = source.lastModified() / 2000L;
                long dts = destination.lastModified() / 2000L;
                if (sts == 0L || sts != dts || source.length() != destination.length()) {
                    MCRWebPagesSynchronizer.copyFile(source, destination, newChuckSize);
                }
            } else {
                MCRWebPagesSynchronizer.copyFile(source, destination, newChuckSize);
            }
        }
    }

    private static void copyFile(File srcFile, File destFile, long chunkSize) throws IOException {
        try (FileInputStream is = new FileInputStream(srcFile);
             FileOutputStream os = new FileOutputStream(destFile, false);){
            long transferredLength;
            FileChannel iChannel = is.getChannel();
            FileChannel oChannel = os.getChannel();
            long doneBytes = 0L;
            for (long todoBytes = srcFile.length(); todoBytes != 0L; todoBytes -= transferredLength) {
                long iterationBytes = Math.min(todoBytes, chunkSize);
                if (iterationBytes != (transferredLength = oChannel.transferFrom(iChannel, doneBytes, iterationBytes))) {
                    throw new IOException("Error during file transfer: expected " + iterationBytes + " bytes, only " + transferredLength + " bytes copied.");
                }
                doneBytes += transferredLength;
            }
        }
        boolean successTimestampOp = destFile.setLastModified(srcFile.lastModified());
        if (!successTimestampOp) {
            LOGGER.warn(String.format(Locale.ROOT, "Could not change timestamp for %s. Index synchronization may be slow.", destFile));
        }
    }

    private static void delete(File file) {
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                MCRWebPagesSynchronizer.delete(subFile);
            }
        }
        if (file.exists() && !file.delete()) {
            LOGGER.warn(String.format(Locale.ROOT, "Could not delete %s.", file));
        }
    }
}

