/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wcms2.navigation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.mycore.common.config.MCRConfiguration2;
import org.mycore.common.content.MCRURLContent;
import org.mycore.tools.MyCoReWebPageProvider;
import org.mycore.wcms2.MCRWebPagesSynchronizer;
import org.mycore.wcms2.navigation.MCRWCMSDefaultSectionProvider;
import org.mycore.wcms2.navigation.MCRWCMSSectionProvider;
import org.xml.sax.SAXException;

public class MCRWCMSContentManager {
    private static final Logger LOGGER = LogManager.getLogger(MCRWCMSContentManager.class);
    private MCRWCMSSectionProvider sectionProvider = MCRConfiguration2.getInstanceOf((String)"MCR.WCMS2.sectionProvider").orElseGet(MCRWCMSDefaultSectionProvider::new);

    public JsonObject getContent(String webpageId) throws IOException, JDOMException, SAXException {
        boolean isXML = webpageId.endsWith(".xml");
        URL resourceURL = null;
        try {
            resourceURL = MCRWebPagesSynchronizer.getURL(webpageId);
        }
        catch (MalformedURLException e) {
            this.throwError(ErrorType.invalidDirectory, webpageId);
        }
        if (!isXML) {
            this.throwError(ErrorType.invalidFile, webpageId);
        }
        Document doc = null;
        if (resourceURL == null) {
            MyCoReWebPageProvider wpp = new MyCoReWebPageProvider();
            wpp.addSection("neuer Eintrag", (Content)new Element("p").setText("TODO"), "de");
            doc = wpp.getXML();
        } else {
            doc = new MCRURLContent(resourceURL).asXML();
        }
        Element rootElement = doc.getRootElement();
        if (!rootElement.getName().equals("MyCoReWebPage")) {
            this.throwError(ErrorType.notMyCoReWebPage, webpageId);
        }
        return this.getContent(rootElement);
    }

    public JsonObject getContent(Element e) {
        JsonArray sectionArray = this.sectionProvider.toJSON(e);
        JsonObject content = new JsonObject();
        content.addProperty("type", "content");
        content.add("content", (JsonElement)sectionArray);
        return content;
    }

    public void save(JsonArray items) {
        XMLOutputter out = new XMLOutputter(Format.getRawFormat().setEncoding("UTF-8"));
        for (JsonElement e : items) {
            this.validateContent(e).ifPresent(item -> {
                String webpageId = this.getWebPageId((JsonObject)item).get();
                if (!webpageId.endsWith(".xml")) {
                    this.throwError(ErrorType.invalidFile, webpageId);
                }
                JsonArray content = item.get("content").getAsJsonArray();
                Element mycoreWebpage = this.sectionProvider.fromJSON(content);
                try (OutputStream fout = MCRWebPagesSynchronizer.getOutputStream(webpageId);){
                    out.output(new Document(mycoreWebpage), fout);
                }
                catch (IOException | RuntimeException exc) {
                    LOGGER.error("Error while saving {}", (Object)webpageId, (Object)exc);
                    this.throwError(ErrorType.couldNotSave, webpageId);
                }
            });
        }
    }

    private Optional<String> getWebPageId(JsonObject item) {
        JsonElement webpageIdElement;
        Object object = item.has("href") ? item.get("href") : (webpageIdElement = item.has("hrefStartingPage") ? item.get("hrefStartingPage") : null);
        if (webpageIdElement == null || !webpageIdElement.isJsonPrimitive()) {
            return Optional.empty();
        }
        return Optional.of(webpageIdElement).map(JsonElement::getAsString);
    }

    private Optional<JsonObject> validateContent(JsonElement e) {
        if (!e.isJsonObject()) {
            LOGGER.warn("Invalid json element in items {}", (Object)e);
            return Optional.empty();
        }
        JsonObject item = e.getAsJsonObject();
        if (!item.has("dirty") || !item.get("dirty").getAsBoolean()) {
            return Optional.empty();
        }
        if (!(this.getWebPageId(item).isPresent() && item.has("content") && item.get("content").isJsonArray())) {
            return Optional.empty();
        }
        return Optional.of(item);
    }

    public void move(String from, String to) {
        try {
            Document document;
            URL fromURL = MCRWebPagesSynchronizer.getURL(from);
            if (fromURL == null) {
                MyCoReWebPageProvider wpp = new MyCoReWebPageProvider();
                wpp.addSection("neuer Eintrag", (Content)new Element("p").setText("TODO"), "de");
                document = wpp.getXML();
            } else {
                SAXBuilder builder = new SAXBuilder();
                document = builder.build(fromURL);
            }
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat().setEncoding("UTF-8"));
            try (OutputStream fout = MCRWebPagesSynchronizer.getOutputStream(to);){
                out.output(document, fout);
            }
            if (fromURL != null) {
                Files.delete(Paths.get(fromURL.toURI()));
            }
        }
        catch (Exception exc) {
            LOGGER.error("Error moving {} to {}", (Object)from, (Object)to, (Object)exc);
            this.throwError(ErrorType.couldNotMove, to);
        }
    }

    private void throwError(ErrorType errorType, String webpageId) {
        JsonObject error = new JsonObject();
        error.addProperty("type", errorType.name());
        error.addProperty("webpageId", webpageId);
        Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
        throw new WebApplicationException(response);
    }

    public static enum ErrorType {
        notExist,
        invalidFile,
        notMyCoReWebPage,
        invalidDirectory,
        couldNotSave,
        couldNotMove;

    }
}

