/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wcms2.navigation;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mycore.common.MCRException;
import org.mycore.frontend.MCRLayoutUtilities;
import org.mycore.wcms2.datamodel.MCRNavigation;
import org.mycore.wcms2.datamodel.MCRNavigationBaseItem;
import org.mycore.wcms2.datamodel.MCRNavigationGroup;
import org.mycore.wcms2.datamodel.MCRNavigationInsertItem;
import org.mycore.wcms2.datamodel.MCRNavigationItem;
import org.mycore.wcms2.datamodel.MCRNavigationItemContainer;
import org.mycore.wcms2.datamodel.MCRNavigationMenuItem;
import org.mycore.wcms2.navigation.MCRWCMSDefaultSectionProvider;
import org.mycore.wcms2.navigation.MCRWCMSNavigationProvider;

public class MCRWCMSDefaultNavigationProvider
implements MCRWCMSNavigationProvider {
    private static final Logger LOGGER = LogManager.getLogger(MCRWCMSDefaultSectionProvider.class);
    private static Gson gson = new Gson();

    @Override
    public JsonObject toJSON(MCRNavigation navigation) {
        JsonObject returnObject = new JsonObject();
        JsonArray hierarchy = new JsonArray();
        JsonArray items = new JsonArray();
        returnObject.add("hierarchy", (JsonElement)hierarchy);
        returnObject.add("items", (JsonElement)items);
        this.create(navigation, hierarchy, items);
        return returnObject;
    }

    private void create(MCRNavigationBaseItem item, JsonArray hierarchy, JsonArray items) throws MCRException {
        JsonObject hierarchyObject = this.add(item, hierarchy, items);
        if (item instanceof MCRNavigationItemContainer) {
            JsonArray childHierarchyArray = new JsonArray();
            for (MCRNavigationBaseItem childItem : ((MCRNavigationItemContainer)item).getChildren()) {
                this.create(childItem, childHierarchyArray, items);
            }
            if (childHierarchyArray.size() > 0) {
                hierarchyObject.add("children", (JsonElement)childHierarchyArray);
            }
        }
    }

    private JsonObject add(MCRNavigationBaseItem item, JsonArray hierarchy, JsonArray items) {
        int id = items.size();
        JsonObject jsonItem = gson.toJsonTree((Object)item).getAsJsonObject();
        jsonItem.addProperty("wcmsId", (Number)id);
        jsonItem.remove("children");
        MCRWCMSNavigationProvider.WCMSType type = null;
        String href = null;
        if (item instanceof MCRNavigation) {
            type = MCRWCMSNavigationProvider.WCMSType.root;
            href = ((MCRNavigation)item).getHrefStartingPage();
        } else if (item instanceof MCRNavigationMenuItem) {
            type = MCRWCMSNavigationProvider.WCMSType.menu;
            href = ((MCRNavigationMenuItem)item).getDir();
        } else if (item instanceof MCRNavigationItem) {
            type = MCRWCMSNavigationProvider.WCMSType.item;
            href = ((MCRNavigationItem)item).getHref();
        } else if (item instanceof MCRNavigationInsertItem) {
            type = MCRWCMSNavigationProvider.WCMSType.insert;
        } else if (item instanceof MCRNavigationGroup) {
            type = MCRWCMSNavigationProvider.WCMSType.group;
        } else {
            LOGGER.warn("Unable to set type for item {}", (Object)id);
        }
        jsonItem.addProperty("wcmsType", type.name());
        if (href != null) {
            jsonItem.add("access", (JsonElement)this.getAccess(href));
        }
        items.add((JsonElement)jsonItem);
        JsonObject hierarchyObject = new JsonObject();
        hierarchyObject.addProperty("wcmsId", (Number)id);
        hierarchy.add((JsonElement)hierarchyObject);
        return hierarchyObject;
    }

    @Override
    public MCRNavigation fromJSON(JsonObject navigationJSON) {
        JsonObject root;
        MCRNavigationBaseItem navigation;
        JsonArray items = navigationJSON.get("items").getAsJsonArray();
        JsonArray hierarchy = navigationJSON.get("hierarchy").getAsJsonArray();
        if (hierarchy.size() > 0 && (navigation = this.createItem(root = hierarchy.get(0).getAsJsonObject(), items)) instanceof MCRNavigation) {
            return (MCRNavigation)navigation;
        }
        return null;
    }

    private MCRNavigationBaseItem createItem(JsonObject hierarchyObject, JsonArray items) {
        if (!hierarchyObject.has("wcmsId")) {
            LOGGER.warn("While saving navigation.xml. Invalid object in hierarchy.");
            return null;
        }
        MCRNavigationBaseItem item = this.getNavigationItem(hierarchyObject.get("wcmsId").getAsString(), items);
        if (item == null) {
            LOGGER.warn("While saving navigation.xml. Item with id {} is null!", (Object)hierarchyObject.get("wcmsId"));
            return null;
        }
        JsonElement children = hierarchyObject.get("children");
        if (children != null && children.isJsonArray() && item instanceof MCRNavigationItemContainer) {
            MCRNavigationItemContainer itemAsContainer = (MCRNavigationItemContainer)item;
            for (JsonElement child : children.getAsJsonArray()) {
                MCRNavigationBaseItem childItem;
                if (!child.isJsonObject() || (childItem = this.createItem(child.getAsJsonObject(), items)) == null) continue;
                itemAsContainer.getChildren().add(childItem);
            }
        }
        return item;
    }

    private MCRNavigationBaseItem getNavigationItem(String wcmsId, JsonArray items) {
        for (JsonElement e : items) {
            JsonObject item;
            if (!e.isJsonObject() || !(item = e.getAsJsonObject()).has("wcmsId") || !item.has("wcmsType") || !wcmsId.equals(item.get("wcmsId").getAsString())) continue;
            MCRWCMSNavigationProvider.WCMSType wcmsType = MCRWCMSNavigationProvider.WCMSType.valueOf(item.get("wcmsType").getAsString());
            if (wcmsType.equals((Object)MCRWCMSNavigationProvider.WCMSType.root)) {
                return (MCRNavigationBaseItem)gson.fromJson((JsonElement)item, MCRNavigation.class);
            }
            if (wcmsType.equals((Object)MCRWCMSNavigationProvider.WCMSType.menu)) {
                return (MCRNavigationBaseItem)gson.fromJson((JsonElement)item, MCRNavigationMenuItem.class);
            }
            if (wcmsType.equals((Object)MCRWCMSNavigationProvider.WCMSType.item)) {
                return (MCRNavigationBaseItem)gson.fromJson((JsonElement)item, MCRNavigationItem.class);
            }
            if (wcmsType.equals((Object)MCRWCMSNavigationProvider.WCMSType.insert)) {
                return (MCRNavigationBaseItem)gson.fromJson((JsonElement)item, MCRNavigationInsertItem.class);
            }
            if (!wcmsType.equals((Object)MCRWCMSNavigationProvider.WCMSType.group)) continue;
            return (MCRNavigationBaseItem)gson.fromJson((JsonElement)item, MCRNavigationGroup.class);
        }
        return null;
    }

    private JsonObject getAccess(String href) {
        JsonObject accessObject = new JsonObject();
        if (MCRLayoutUtilities.hasRule((String)"read", (String)href)) {
            JsonObject readObject = new JsonObject();
            accessObject.add("read", (JsonElement)readObject);
            readObject.addProperty("ruleID", MCRLayoutUtilities.getRuleID((String)"read", (String)href));
            readObject.addProperty("ruleDes", MCRLayoutUtilities.getRuleDescr((String)"read", (String)href));
        }
        if (MCRLayoutUtilities.hasRule((String)"write", (String)href)) {
            JsonObject writeObject = new JsonObject();
            accessObject.add("write", (JsonElement)writeObject);
            writeObject.addProperty("ruleID", MCRLayoutUtilities.getRuleID((String)"write", (String)href));
            writeObject.addProperty("ruleDes", MCRLayoutUtilities.getRuleDescr((String)"write", (String)href));
        }
        return accessObject;
    }
}

