/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wcms2.navigation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.WebApplicationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.output.XMLOutputter;
import org.mycore.common.MCRSessionMgr;
import org.mycore.common.config.MCRConfiguration2;
import org.mycore.tools.MyCoReWebPageProvider;
import org.mycore.wcms2.navigation.MCRWCMSSectionProvider;
import org.xml.sax.SAXParseException;

public class MCRWCMSDefaultSectionProvider
implements MCRWCMSSectionProvider {
    private static final Logger LOGGER = LogManager.getLogger(MCRWCMSDefaultSectionProvider.class);
    private static final List<String> HTML_TAG_LIST = Arrays.asList("html", "head", "title", "base", "link", "meta", "style", "script", "noscript", "body", "body", "section", "nav", "article", "aside", "h1", "h2", "h3", "h4", "h5", "h6", "header", "footer", "address", "main", "p", "hr", "pre", "blockquote", "ol", "ul", "li", "dl", "dt", "dd", "figure", "figcaption", "div", "a", "em", "strong", "small", "s", "cite", "q", "dfn", "abbr", "data", "time", "code", "var", "samp", "kbd", "sub", "sup", "i", "b", "u", "mark", "ruby", "rt", "rp", "bdi", "bdo", "span", "br", "wbr", "ins", "del", "img", "iframe", "embed", "object", "param", "video", "audio", "source", "track", "canvas", "map", "area", "svg", "math", "table", "caption", "colgroup", "col", "tbody", "thead", "tfoot", "tr", "td", "th", "form", "fieldset", "legend", "label", "input", "button", "select", "datalist", "optgroup", "option", "textarea", "keygen", "output", "progress", "meter", "details", "summary", "menuitem", "menu", "font");
    private List<String> mycoreTagList = new ArrayList<String>();

    public MCRWCMSDefaultSectionProvider() {
        String mycoreTagListString = MCRConfiguration2.getString((String)"MCR.WCMS2.mycoreTagList").orElse("");
        for (String tag : mycoreTagListString.split(",")) {
            this.mycoreTagList.add(tag.trim());
        }
    }

    @Override
    public JsonArray toJSON(Element rootElement) {
        JsonArray sectionArray = new JsonArray();
        for (Element section : rootElement.getChildren("section")) {
            String invalidElementName;
            String title = section.getAttributeValue("title");
            String lang = section.getAttributeValue("lang", Namespace.XML_NAMESPACE);
            String data = null;
            if (section.getContent((Filter)new ElementFilter()).size() > 1) {
                Element div = new Element("div");
                while (section.getChildren().size() > 0) {
                    div.addContent((Content)((Element)section.getChildren().get(0)).detach());
                }
                section.addContent((Content)div);
            }
            try {
                data = this.getContent(section);
            }
            catch (IOException ioExc) {
                LOGGER.error("while reading section data.", (Throwable)ioExc);
                continue;
            }
            JsonObject jsonObject = new JsonObject();
            if (title != null && !title.equals("")) {
                jsonObject.addProperty("title", title);
            }
            if (lang != null && !lang.equals("")) {
                jsonObject.addProperty("lang", lang);
            }
            if ((invalidElementName = this.validateElement(section)) != null) {
                jsonObject.addProperty("hidden", "true");
                jsonObject.addProperty("invalidElement", invalidElementName);
            }
            jsonObject.addProperty("data", data);
            sectionArray.add((JsonElement)jsonObject);
        }
        return sectionArray;
    }

    private String validateElement(Element element) {
        String elementName = element.getName().toLowerCase(Locale.ROOT);
        if (!HTML_TAG_LIST.contains(elementName) && !this.mycoreTagList.contains(elementName)) {
            return elementName;
        }
        for (Element el : element.getChildren()) {
            String childElementName = this.validateElement(el);
            if (childElementName == null) continue;
            return childElementName;
        }
        return null;
    }

    protected String getContent(Element e) throws IOException {
        XMLOutputter out = new XMLOutputter();
        StringWriter writer = new StringWriter();
        for (Content child : e.getContent()) {
            Text t;
            String trimmedText;
            if (child instanceof Element) {
                out.output((Element)child, (Writer)writer);
                continue;
            }
            if (!(child instanceof Text) || "".equals(trimmedText = (t = (Text)child).getTextTrim())) continue;
            Text newText = new Text(trimmedText);
            out.output(newText, (Writer)writer);
        }
        return writer.toString();
    }

    @Override
    public Element fromJSON(JsonArray jsonSectionArray) {
        MyCoReWebPageProvider wp = new MyCoReWebPageProvider();
        for (JsonElement sectionElement : jsonSectionArray) {
            if (!sectionElement.isJsonObject()) {
                LOGGER.warn("Invalid json element in content array! {}", (Object)sectionElement);
                continue;
            }
            JsonObject sectionObject = sectionElement.getAsJsonObject();
            String title = null;
            String lang = null;
            if (sectionObject.has("title")) {
                title = sectionObject.get("title").getAsJsonPrimitive().getAsString();
            }
            if (sectionObject.has("lang")) {
                lang = sectionObject.get("lang").getAsJsonPrimitive().getAsString();
            }
            String xmlAsString = sectionObject.get("data").getAsJsonPrimitive().getAsString();
            try {
                wp.addSection(title, xmlAsString, lang);
            }
            catch (IOException | JDOMException | SAXParseException exc) {
                throw new WebApplicationException("unable to add section " + title, exc);
            }
        }
        wp.updateMeta(MCRSessionMgr.getCurrentSession().getUserInformation().getUserID(), null);
        return wp.getXML().detachRootElement();
    }
}

