/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wcms2.navigation;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.mycore.common.config.MCRConfiguration2;
import org.mycore.common.xml.MCRDOMUtils;
import org.mycore.frontend.MCRLayoutUtilities;
import org.mycore.wcms2.MCRWCMSUtil;
import org.mycore.wcms2.MCRWebPagesSynchronizer;
import org.mycore.wcms2.datamodel.MCRNavigation;
import org.mycore.wcms2.datamodel.MCRNavigationBaseItem;
import org.mycore.wcms2.datamodel.MCRNavigationItem;
import org.mycore.wcms2.datamodel.MCRNavigationItemContainer;
import org.mycore.wcms2.navigation.MCRWCMSDefaultNavigationProvider;
import org.mycore.wcms2.navigation.MCRWCMSNavigationProvider;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MCRWCMSNavigationUtils {
    private static MCRWCMSNavigationProvider NAVIGATION_PROVIDER = MCRConfiguration2.getInstanceOf((String)"MCR.WCMS2.navigationProvider").orElseGet(MCRWCMSDefaultNavigationProvider::new);

    public static synchronized JsonObject toJSON(MCRNavigation navigation) {
        return NAVIGATION_PROVIDER.toJSON(navigation);
    }

    public static synchronized MCRNavigation fromJSON(JsonObject jsonNavigation) {
        return NAVIGATION_PROVIDER.fromJSON(jsonNavigation);
    }

    public static void save(MCRNavigation navigation) throws IOException, JAXBException, JDOMException {
        OutputStream out = MCRWebPagesSynchronizer.getOutputStream(MCRLayoutUtilities.NAV_RESOURCE);
        MCRWCMSUtil.save(navigation, out);
        out.flush();
        out.close();
    }

    public static synchronized JsonObject getNavigationAsJSON() throws IOException, SAXException, JAXBException {
        return NAVIGATION_PROVIDER.toJSON(MCRWCMSNavigationUtils.getNavigation());
    }

    public static synchronized Document getNavigationAsXML() {
        return MCRLayoutUtilities.getNavi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MCRNavigation getNavigation() throws IOException, SAXException, JAXBException {
        DocumentBuilder documentBuilder = MCRDOMUtils.getDocumentBuilderUnchecked();
        try {
            org.w3c.dom.Document doc = documentBuilder.parse(MCRLayoutUtilities.getNavigationURL().toString());
            if (doc.getElementsByTagName("menu").getLength() == 0) {
                NodeList nodeList = doc.getFirstChild().getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    if (nodeList.item(i).getNodeType() != 1) continue;
                    ((Element)nodeList.item(i)).setAttribute("id", nodeList.item(i).getNodeName());
                    doc.renameNode(nodeList.item(i), null, "menu");
                }
            } else {
                MCRConfiguration2.set((String)"MCR.NavigationFile.SaveInOldFormat", (String)String.valueOf(false));
            }
            MCRNavigation mCRNavigation = MCRWCMSUtil.load(doc);
            return mCRNavigation;
        }
        finally {
            MCRDOMUtils.releaseDocumentBuilder((DocumentBuilder)documentBuilder);
        }
    }

    public static boolean updateHref(MCRNavigationBaseItem item, String from, String to) {
        MCRNavigationItem navItem;
        boolean dirty = false;
        if (item instanceof MCRNavigation) {
            MCRNavigation navigation = (MCRNavigation)item;
            if (navigation.getHrefStartingPage() != null && navigation.getHrefStartingPage().equals(from)) {
                navigation.setHrefStartingPage(to);
                dirty = true;
            }
        } else if (item instanceof MCRNavigationItem && (navItem = (MCRNavigationItem)item).getHref().equals(from)) {
            navItem.setHref(to);
            dirty = true;
        }
        if (item instanceof MCRNavigationItemContainer) {
            MCRNavigationItemContainer container = (MCRNavigationItemContainer)item;
            for (MCRNavigationBaseItem child : container.getChildren()) {
                if (!MCRWCMSNavigationUtils.updateHref(child, from, to)) continue;
                dirty = true;
            }
        }
        return dirty;
    }
}

