/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wcms2.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Date;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.mycore.access.mcrimpl.MCRAccessRule;
import org.mycore.access.mcrimpl.MCRAccessStore;
import org.mycore.access.mcrimpl.MCRRuleMapping;
import org.mycore.access.mcrimpl.MCRRuleStore;
import org.mycore.common.MCRSessionMgr;
import org.mycore.frontend.MCRLayoutUtilities;
import org.mycore.frontend.jersey.filter.access.MCRRestrictedAccess;
import org.mycore.wcms2.access.MCRWCMSPermission;

@Path(value="wcms/access")
@MCRRestrictedAccess(value=MCRWCMSPermission.class)
public class MCRWCMSAccessResource {
    @DELETE
    public String delete(@QueryParam(value="webPageID") String webPageID, @QueryParam(value="perm") String perm) {
        JsonObject returnObject = new JsonObject();
        if (!MCRLayoutUtilities.hasRule((String)perm, (String)webPageID)) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        MCRAccessStore accessStore = MCRAccessStore.getInstance();
        MCRRuleMapping ruleMap = accessStore.getAccessDefinition(perm, MCRLayoutUtilities.getWebpageACLID((String)webPageID));
        accessStore.deleteAccessDefinition(ruleMap);
        JsonObject doneObject = new JsonObject();
        returnObject.addProperty("type", "editDone");
        returnObject.add("edit", (JsonElement)doneObject);
        return returnObject.toString();
    }

    @POST
    public String createOrUpdate(@QueryParam(value="webPageID") String webPageID, @QueryParam(value="perm") String perm, @QueryParam(value="ruleID") String ruleID) {
        MCRRuleMapping ruleMap;
        MCRAccessStore accessStore = MCRAccessStore.getInstance();
        JsonObject returnObject = new JsonObject();
        if (MCRLayoutUtilities.hasRule((String)perm, (String)webPageID)) {
            ruleMap = accessStore.getAccessDefinition(perm, MCRLayoutUtilities.getWebpageACLID((String)webPageID));
            ruleMap.setRuleId(ruleID);
            accessStore.updateAccessDefinition(ruleMap);
        } else {
            ruleMap = new MCRRuleMapping();
            ruleMap.setCreator(MCRSessionMgr.getCurrentSession().getUserInformation().getUserID());
            ruleMap.setCreationdate(new Date());
            ruleMap.setPool(perm);
            ruleMap.setRuleId(ruleID);
            ruleMap.setObjId(MCRLayoutUtilities.getWebpageACLID((String)webPageID));
            accessStore.createAccessDefinition(ruleMap);
        }
        JsonObject doneObject = new JsonObject();
        returnObject.addProperty("type", "editDone");
        returnObject.add("edit", (JsonElement)doneObject);
        doneObject.addProperty("ruleId", MCRLayoutUtilities.getRuleID((String)perm, (String)webPageID));
        doneObject.addProperty("ruleDes", MCRLayoutUtilities.getRuleDescr((String)perm, (String)webPageID));
        return returnObject.toString();
    }

    @GET
    public String getRuleList() {
        JsonObject returnObject = new JsonObject();
        MCRRuleStore store = MCRRuleStore.getInstance();
        Collection ruleIds = store.retrieveAllIDs();
        for (String id : ruleIds) {
            MCRAccessRule rule = store.getRule(id);
            returnObject.addProperty(rule.getId(), rule.getDescription());
        }
        return returnObject.toString();
    }
}

