/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wcms2.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.mycore.frontend.MCRLayoutUtilities;
import org.mycore.frontend.jersey.filter.access.MCRRestrictedAccess;
import org.mycore.wcms2.MCRWebPagesSynchronizer;
import org.mycore.wcms2.access.MCRWCMSPermission;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Path(value="wcms2/filebrowser")
@MCRRestrictedAccess(value=MCRWCMSPermission.class)
public class MCRWCMSFileBrowserResource {
    private ArrayList<String> folderList = new ArrayList();
    private String wcmsDataPath = MCRWebPagesSynchronizer.getWCMSDataDir().getPath();
    private static final Logger LOGGER = LogManager.getLogger(MCRWCMSFileBrowserResource.class);
    @Context
    HttpServletRequest request;
    @Context
    HttpServletResponse response;
    @Context
    ServletContext context;

    @GET
    public InputStream getFileBrowser() throws Exception {
        return this.getClass().getResourceAsStream("/META-INF/resources/modules/wcms2/filebrowser.html");
    }

    @GET
    @Path(value="gui/{filename:.*}")
    public Response getResources(@PathParam(value="filename") String filename) {
        if (filename.endsWith(".js")) {
            return Response.ok((Object)this.getClass().getResourceAsStream("/META-INF/resources/modules/wcms2/" + filename)).header("Content-Type", (Object)"application/javascript").build();
        }
        if (filename.endsWith(".css")) {
            return Response.ok((Object)this.getClass().getResourceAsStream("/META-INF/resources/modules/wcms2/" + filename)).header("Content-Type", (Object)"text/css").build();
        }
        return Response.ok((Object)this.getClass().getResourceAsStream("/META-INF/resources/modules/wcms2/" + filename)).build();
    }

    @GET
    @Path(value="/folder")
    public String getFolders() throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        File file = new File(MCRLayoutUtilities.getNavigationURL().getPath());
        Document doc = docBuilder.parse(file);
        this.getallowedPaths(doc.getDocumentElement());
        File dir = MCRWebPagesSynchronizer.getWCMSDataDir();
        JsonObject jsonObj = new JsonObject();
        jsonObj.add("folders", (JsonElement)this.getFolder(dir, false));
        return jsonObj.toString();
    }

    @POST
    @Path(value="/folder")
    public Response addFolder(@QueryParam(value="path") String path) throws IOException {
        File wcmsDir = new File(MCRWebPagesSynchronizer.getWCMSDataDir().getPath() + path);
        File wepAppdir = new File(MCRWebPagesSynchronizer.getWebAppBaseDir().getPath() + path);
        if (wcmsDir.mkdir() && wepAppdir.mkdir()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).build();
    }

    @DELETE
    @Path(value="/folder")
    public Response deleteFolder(@QueryParam(value="path") String path) throws IOException {
        File wcmsDir = new File(MCRWebPagesSynchronizer.getWCMSDataDir().getPath() + path);
        File wepAppdir = new File(MCRWebPagesSynchronizer.getWebAppBaseDir().getPath() + path);
        if (wepAppdir.isDirectory()) {
            if (wepAppdir.list().length < 1) {
                if (FileUtils.deleteQuietly((File)wepAppdir) && FileUtils.deleteQuietly((File)wcmsDir)) {
                    return Response.ok().build();
                }
            } else {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).build();
    }

    @GET
    @Path(value="/files")
    public String getFiles(@QueryParam(value="path") String path, @QueryParam(value="type") String type) throws IOException {
        File dir = new File(MCRWebPagesSynchronizer.getWCMSDataDir().getPath() + path);
        JsonObject jsonObj = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        File[] fileArray = dir.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                String mimetype = Files.probeContentType(file.toPath());
                if (mimetype == null || !(type.equals("images") ? mimetype.split("/")[0].equals("image") : !mimetype.split("/")[1].contains("xml"))) continue;
                JsonObject fileJsonObj = new JsonObject();
                fileJsonObj.addProperty("name", file.getName());
                fileJsonObj.addProperty("path", this.context.getContextPath() + path + "/" + file.getName());
                if (file.isDirectory()) {
                    fileJsonObj.addProperty("type", "folder");
                } else {
                    fileJsonObj.addProperty("type", mimetype.split("/")[0]);
                }
                jsonArray.add((JsonElement)fileJsonObj);
            }
            jsonObj.add("files", (JsonElement)jsonArray);
            return jsonObj.toString();
        }
        return "";
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response getUpload(@FormDataParam(value="file") InputStream inputStream, @FormDataParam(value="file") FormDataContentDisposition header, @FormDataParam(value="path") String path) {
        try {
            this.saveFile(inputStream, path + "/" + header.getFileName());
        }
        catch (IOException e) {
            LOGGER.error("Error while saving {}", (Object)path, (Object)e);
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        return Response.ok().build();
    }

    @DELETE
    public Response deleteFile(@QueryParam(value="path") String path) throws IOException {
        File wcmsDir = new File(MCRWebPagesSynchronizer.getWCMSDataDir().getPath() + path);
        File wepAppdir = new File(MCRWebPagesSynchronizer.getWebAppBaseDir().getPath() + path);
        if (MCRWCMSFileBrowserResource.delete(wcmsDir) && MCRWCMSFileBrowserResource.delete(wepAppdir)) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).build();
    }

    @POST
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    public String getUpload(@FormDataParam(value="upload") InputStream inputStream, @FormDataParam(value="upload") FormDataContentDisposition header, @QueryParam(value="CKEditorFuncNum") int funcNum, @QueryParam(value="href") String href, @QueryParam(value="type") String type, @QueryParam(value="basehref") String basehref) {
        String path = "";
        try {
            path = this.saveFile(inputStream, href + "/" + header.getFileName());
        }
        catch (IOException e) {
            LOGGER.error("Error while saving {}", (Object)(href + "/" + header.getFileName()), (Object)e);
            return "";
        }
        if ("images".equals(type)) {
            return "<script type='text/javascript'>window.parent.CKEDITOR.tools.callFunction(" + funcNum + ",'" + path.substring(path.lastIndexOf("/") + 1) + "', '');</script>";
        }
        return "<script type='text/javascript'>window.parent.CKEDITOR.tools.callFunction(" + funcNum + ",'" + basehref + path.substring(path.lastIndexOf("/") + 1) + "', '');</script>";
    }

    protected String saveFile(InputStream inputStream, String path) throws IOException {
        String newPath = this.testIfFileExists(path);
        OutputStream outputStream = MCRWebPagesSynchronizer.getOutputStream(newPath);
        int read = 0;
        byte[] bytes = new byte[1024];
        while ((read = inputStream.read(bytes)) != -1) {
            outputStream.write(bytes, 0, read);
        }
        outputStream.flush();
        outputStream.close();
        return newPath;
    }

    protected String testIfFileExists(String path) {
        Object newPath = path;
        File file = new File(MCRWebPagesSynchronizer.getWCMSDataDir().getPath() + (String)newPath);
        int i = 1;
        while (file.exists()) {
            String type = ((String)newPath).substring(((String)newPath).lastIndexOf("."));
            String name = ((String)newPath).substring(0, ((String)newPath).lastIndexOf("."));
            if (i > 1) {
                name = name.substring(0, name.lastIndexOf("("));
            }
            newPath = name + "(" + i++ + ")" + type;
            file = new File(MCRWebPagesSynchronizer.getWCMSDataDir().getPath() + (String)newPath);
        }
        return newPath;
    }

    protected void getallowedPaths(Element element) {
        String pathString = element.getAttribute("dir");
        if (!"".equals(pathString)) {
            this.folderList.add(this.wcmsDataPath + pathString);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this.getallowedPaths((Element)node);
        }
    }

    protected JsonObject getFolder(File node, boolean folderallowed) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty("name", node.getName());
        jsonObj.addProperty("path", node.getAbsolutePath());
        jsonObj.addProperty("allowed", Boolean.valueOf(folderallowed));
        if (node.isDirectory()) {
            File[] childNodes;
            jsonObj.addProperty("type", "folder");
            JsonArray jsonArray = new JsonArray();
            for (File child : childNodes = node.listFiles()) {
                if (!child.isDirectory()) continue;
                if (folderallowed || this.folderList.contains(child.getPath())) {
                    jsonArray.add((JsonElement)this.getFolder(child, true));
                    continue;
                }
                jsonArray.add((JsonElement)this.getFolder(child, false));
            }
            if (jsonArray.size() > 0) {
                jsonObj.add("children", (JsonElement)jsonArray);
            }
            return jsonObj;
        }
        return jsonObj;
    }

    protected static boolean delete(File file) {
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                MCRWCMSFileBrowserResource.delete(subFile);
            }
        }
        return !file.exists() || file.delete();
    }
}

