/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wcms2.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonStreamParser;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mycore.common.config.MCRConfiguration2;
import org.mycore.frontend.jersey.filter.access.MCRRestrictedAccess;
import org.mycore.wcms2.access.MCRWCMSPermission;
import org.mycore.wcms2.datamodel.MCRNavigation;
import org.mycore.wcms2.navigation.MCRWCMSContentManager;
import org.mycore.wcms2.navigation.MCRWCMSNavigationUtils;

@Path(value="wcms/navigation")
@MCRRestrictedAccess(value=MCRWCMSPermission.class)
public class MCRWCMSNavigationResource {
    private static final XPathExpression<Element> TEMPLATE_PATH = XPathFactory.instance().compile("*[@template]", Filters.element());

    @GET
    @Produces(value={"application/json"})
    public String get() {
        try {
            JsonObject json = MCRWCMSNavigationUtils.getNavigationAsJSON();
            return json.toString();
        }
        catch (Exception exc) {
            throw new WebApplicationException((Throwable)exc, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="content")
    @Produces(value={"application/json"})
    public String getContent(@QueryParam(value="webpagePath") String webpagePath) throws Exception {
        JsonObject json = this.getContentManager().getContent(webpagePath);
        return json.toString();
    }

    @POST
    @Path(value="save")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response save(String json) throws Exception {
        JsonStreamParser jsonStreamParser = new JsonStreamParser(json);
        if (!jsonStreamParser.hasNext()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        JsonObject saveObject = jsonStreamParser.next().getAsJsonObject();
        MCRNavigation newNavigation = MCRWCMSNavigationUtils.fromJSON(saveObject);
        MCRWCMSNavigationUtils.save(newNavigation);
        JsonArray items = saveObject.get("items").getAsJsonArray();
        this.getContentManager().save(items);
        return Response.ok().build();
    }

    @GET
    @Path(value="templates")
    @Produces(value={"application/json"})
    public String getTemplates(@Context ServletContext servletContext) throws Exception {
        Document xml = MCRWCMSNavigationUtils.getNavigationAsXML();
        List elementList = TEMPLATE_PATH.evaluate((Object)xml);
        HashSet entries = elementList.stream().map(e -> e.getAttributeValue("template")).collect(Collectors.toCollection(HashSet::new));
        String templatePath = MCRConfiguration2.getString((String)"MCR.WCMS2.templatePath").orElse("/templates/master/");
        Set resourcePaths = servletContext.getResourcePaths(templatePath);
        if (resourcePaths != null) {
            for (String resourcepath : resourcePaths) {
                String newResourcepath = resourcepath.substring(templatePath.length(), resourcepath.length() - 1);
                entries.add(newResourcepath);
            }
        }
        JsonArray returnArr = new JsonArray();
        for (String entry : entries) {
            returnArr.add((JsonElement)new JsonPrimitive(entry));
        }
        return returnArr.toString();
    }

    @POST
    @Path(value="move")
    public void move(@QueryParam(value="from") String from, @QueryParam(value="to") String to) throws Exception {
        if (from == null || to == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"from or to parameter not set").build());
        }
        this.getContentManager().move(from, to);
        MCRNavigation navigation = MCRWCMSNavigationUtils.getNavigation();
        boolean hrefUpdated = MCRWCMSNavigationUtils.updateHref(navigation, from, to);
        if (hrefUpdated) {
            MCRWCMSNavigationUtils.save(navigation);
        }
    }

    protected MCRWCMSContentManager getContentManager() {
        return new MCRWCMSContentManager();
    }
}

