/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wfc.actionmapping;

import com.google.common.base.Splitter;
import java.net.URI;
import java.util.List;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mycore.frontend.servlets.MCRServlet;
import org.mycore.frontend.servlets.MCRServletJob;
import org.mycore.wfc.actionmapping.MCRURLRetriever;

@WebServlet(name="Action Mapping", urlPatterns={"/servlets/MCRActionMappingServlet/*"})
public class MCRActionMappingServlet
extends MCRServlet {
    private static final long serialVersionUID = 1L;
    private static Splitter PATH_SPLITTER = Splitter.on((char)'/').trimResults().omitEmptyStrings().limit(2);

    protected void doGet(MCRServletJob job) throws Exception {
        HttpServletRequest request = job.getRequest();
        String pathInfo = request.getPathInfo();
        HttpServletResponse response = job.getResponse();
        if (pathInfo != null) {
            List splitted = PATH_SPLITTER.splitToList((CharSequence)pathInfo);
            if (splitted.size() == 2) {
                String collection = (String)splitted.get(0);
                String action = (String)splitted.get(1);
                String url = MCRURLRetriever.getURLforCollection(action, collection, true);
                if (url != null) {
                    URI uri = URI.create(url);
                    response.sendRedirect(response.encodeRedirectURL(uri.toString()));
                } else {
                    response.sendError(404);
                }
                return;
            }
            response.sendError(400);
            return;
        }
        response.sendError(412);
    }
}

