/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wfc.actionmapping;

import org.apache.logging.log4j.LogManager;
import org.jdom2.Element;
import org.mycore.datamodel.classifications2.MCRCategLinkReference;
import org.mycore.datamodel.classifications2.MCRCategLinkService;
import org.mycore.datamodel.classifications2.MCRCategLinkServiceFactory;
import org.mycore.datamodel.classifications2.MCRCategoryID;
import org.mycore.parsers.bool.MCRCondition;
import org.mycore.wfc.actionmapping.MCRWorkflowData;

public class MCRCategoryCondition
implements MCRCondition<MCRWorkflowData> {
    private MCRCategoryID mcrCategoryID;
    private boolean not;
    private String fieldName;
    private static MCRCategLinkService LINK_SERVICE = MCRCategLinkServiceFactory.getInstance();

    public MCRCategoryCondition(String fieldName, MCRCategoryID mcrCategoryID, boolean not) {
        this.fieldName = fieldName;
        this.mcrCategoryID = mcrCategoryID;
        this.not = not;
    }

    public boolean evaluate(MCRWorkflowData workflowData) {
        MCRCategLinkReference reference = workflowData.getCategoryReference();
        if (reference == null) {
            LogManager.getLogger(this.getClass()).error("Cannot evaluate '{}', if MCRWorkflowData does not contain an object reference", (Object)this.toString());
            return false;
        }
        return LINK_SERVICE.isInCategory(reference, this.mcrCategoryID) ^ this.not;
    }

    public String toString() {
        return this.fieldName + (this.not ? " != " : " = ") + this.mcrCategoryID.getID() + " ";
    }

    public Element toXML() {
        Element cond = new Element("condition");
        cond.setAttribute("field", this.fieldName);
        cond.setAttribute("operator", this.not ? "!=" : "=");
        cond.setAttribute("value", this.mcrCategoryID.getID());
        return cond;
    }
}

