/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wfc.actionmapping;

import java.util.Collection;
import org.mycore.datamodel.classifications2.MCRCategLinkReference;
import org.mycore.datamodel.classifications2.MCRCategLinkService;
import org.mycore.datamodel.classifications2.MCRCategLinkServiceFactory;
import org.mycore.datamodel.classifications2.MCRCategoryID;
import org.mycore.datamodel.common.MCRLinkTableManager;
import org.mycore.datamodel.metadata.MCRObjectID;
import org.mycore.wfc.MCRConstants;

public class MCRClassificationUtils {
    private static final MCRCategLinkService LINK_SERVICE = MCRCategLinkServiceFactory.getInstance();
    private static final MCRLinkTableManager LINK_TABLE = MCRLinkTableManager.instance();

    public static boolean isInCollection(String mcrId, String collection) {
        MCRObjectID mcrObjectID = MCRObjectID.getInstance((String)mcrId);
        MCRCategoryID collectionID = new MCRCategoryID(MCRConstants.COLLECTION_CLASS_ID.getRootID(), collection);
        MCRCategLinkReference reference = new MCRCategLinkReference(mcrObjectID);
        return LINK_SERVICE.isInCategory(reference, collectionID);
    }

    public static String getCollection(String mcrId) {
        MCRObjectID mcrObjectID = MCRObjectID.getInstance((String)mcrId);
        if (mcrObjectID.getTypeId().equals("derivate")) {
            return MCRClassificationUtils.getCollectionFromDerivate(mcrObjectID);
        }
        return MCRClassificationUtils.getCollectionFromObject(mcrObjectID);
    }

    private static String getCollectionFromObject(MCRObjectID mcrObjectID) {
        MCRCategLinkReference reference = new MCRCategLinkReference(mcrObjectID);
        return LINK_SERVICE.getLinksFromReference(reference).stream().filter(categID -> categID.getRootID().equals(MCRConstants.COLLECTION_CLASS_ID.getRootID())).findFirst().map(MCRCategoryID::getID).orElse(null);
    }

    private static String getCollectionFromDerivate(MCRObjectID mcrObjectID) {
        Collection sourceOf = LINK_TABLE.getSourceOf(mcrObjectID, "derivate");
        if (sourceOf.isEmpty()) {
            return null;
        }
        MCRObjectID metaObjectID = MCRObjectID.getInstance((String)((String)sourceOf.iterator().next()));
        return MCRClassificationUtils.getCollectionFromObject(metaObjectID);
    }
}

