/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wfc.actionmapping;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mycore.common.MCRSession;
import org.mycore.common.MCRSessionMgr;
import org.mycore.frontend.servlets.MCRServlet;
import org.mycore.wfc.actionmapping.MCRClassificationUtils;
import org.mycore.wfc.actionmapping.MCRURLRetriever;

public class MCRPersistenceServletFilter
implements Filter {
    private static final Logger LOGGER = LogManager.getLogger(MCRPersistenceServletFilter.class);

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String url;
        HttpServletRequest req = (HttpServletRequest)request;
        if (req.getServletPath().length() > 0 && (url = this.getURL(req)) != null) {
            this.prepareRequest(req);
            req.getRequestDispatcher(url).forward((ServletRequest)req, response);
            return;
        }
        chain.doFilter((ServletRequest)req, response);
    }

    private void prepareRequest(HttpServletRequest req) {
        Map parameterMap = req.getParameterMap();
        block4: for (Map.Entry entry : parameterMap.entrySet()) {
            switch (((String[])entry.getValue()).length) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    if (((String)entry.getKey()).equals("layout")) continue block4;
                    req.setAttribute((String)entry.getKey(), (Object)((String[])entry.getValue())[0]);
                    continue block4;
                }
            }
            req.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getURL(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        String[] pathElements = servletPath.split("/");
        String type = pathElements[2];
        String operation = pathElements[3];
        MCRSession session = MCRServlet.getSession((HttpServletRequest)req);
        MCRSessionMgr.setCurrentSession((MCRSession)session);
        session.beginTransaction();
        try {
            String url;
            String mcrId = MCRServlet.getProperty((HttpServletRequest)req, (String)"id");
            if (mcrId == null) {
                String collection = this.getCollection(req);
                url = MCRURLRetriever.getURLforCollection(operation, collection, false);
            } else {
                url = MCRURLRetriever.getURLforID(operation, mcrId, false);
            }
            LOGGER.info("Matched URL: {}", (Object)url);
            String string = url;
            return string;
        }
        finally {
            session.commitTransaction();
            MCRSessionMgr.releaseCurrentSession();
        }
    }

    private String getCollection(HttpServletRequest req) {
        String layout = MCRServlet.getProperty((HttpServletRequest)req, (String)"layout");
        if (layout != null) {
            return layout;
        }
        String mcrId = MCRServlet.getProperty((HttpServletRequest)req, (String)"id");
        return MCRClassificationUtils.getCollection(mcrId);
    }

    public void init(FilterConfig config) throws ServletException {
    }
}

