/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wfc.actionmapping;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mycore.common.MCRException;
import org.mycore.datamodel.classifications2.MCRCategLinkReference;
import org.mycore.datamodel.classifications2.MCRCategory;
import org.mycore.datamodel.classifications2.MCRCategoryDAO;
import org.mycore.datamodel.classifications2.MCRCategoryDAOFactory;
import org.mycore.datamodel.classifications2.MCRCategoryID;
import org.mycore.datamodel.metadata.MCRObjectID;
import org.mycore.frontend.MCRFrontendUtil;
import org.mycore.wfc.MCRConstants;
import org.mycore.wfc.actionmapping.MCRAction;
import org.mycore.wfc.actionmapping.MCRActionMappings;
import org.mycore.wfc.actionmapping.MCRActionMappingsManager;
import org.mycore.wfc.actionmapping.MCRClassificationUtils;
import org.mycore.wfc.actionmapping.MCRCollection;
import org.mycore.wfc.actionmapping.MCRWorkflowData;

public final class MCRURLRetriever {
    private static final Logger LOGGER = LogManager.getLogger(MCRURLRetriever.class);
    private static final MCRCategoryDAO CATEGORY_DAO = MCRCategoryDAOFactory.getInstance();
    private static Map<String, MCRCollection> COLLECTION_MAP = MCRURLRetriever.initActionsMappings();

    private MCRURLRetriever() {
    }

    private static Map<String, MCRCollection> initActionsMappings() {
        try {
            MCRActionMappings actionMappings = MCRActionMappingsManager.getActionMappings();
            return Arrays.stream(actionMappings.getCollections()).collect(Collectors.toMap(MCRCollection::getName, c -> c));
        }
        catch (Exception e) {
            throw new MCRException((Throwable)e);
        }
    }

    public static String getURLforID(String action, String mcrID, boolean absolute) {
        MCRObjectID objID = MCRObjectID.getInstance((String)mcrID);
        String collectionName = MCRClassificationUtils.getCollection(mcrID);
        return MCRURLRetriever.getURL(action, collectionName, new MCRCategLinkReference(objID), absolute);
    }

    public static String getURLforCollection(String action, String collection, boolean absolute) {
        return MCRURLRetriever.getURL(action, collection, null, absolute);
    }

    private static String getURL(String action, String collectionName, MCRCategLinkReference reference, boolean absolute) {
        MCRCollection defaultCollection = reference != null ? MCRURLRetriever.getCollectionWithAction(reference.getType(), action, null) : null;
        MCRCollection collection = MCRURLRetriever.getCollectionWithAction(collectionName, action, defaultCollection);
        if (collection == null) {
            LOGGER.warn("Could not find action ''{}'' in collection: {}", (Object)action, (Object)collectionName);
            return null;
        }
        return MCRURLRetriever.getURL(action, collection, reference, absolute);
    }

    private static String getURL(String action, MCRCollection collection, MCRCategLinkReference categoryReference, boolean absolute) {
        for (MCRAction act : collection.getActions()) {
            if (!act.getAction().equals(action)) continue;
            if (LOGGER.isDebugEnabled()) {
                String mcrId = categoryReference == null ? null : categoryReference.getObjectID();
                LOGGER.debug("Collection: {}, Action: {}, Object: {}", (Object)collection.getName(), (Object)action, (Object)mcrId);
            }
            Object url = act.getURL(new MCRWorkflowData(categoryReference));
            if (absolute && url != null && ((String)url).startsWith("/")) {
                url = MCRFrontendUtil.getBaseURL() + ((String)url).substring(1);
            }
            return url;
        }
        return null;
    }

    private static MCRCollection getCollectionWithAction(String collection, String action, MCRCollection defaultCollection) {
        String defaultCollectionName;
        Optional<MCRAction> firstAction;
        MCRCollection mcrCollection = COLLECTION_MAP.get(collection);
        if (mcrCollection != null && (firstAction = Arrays.stream(mcrCollection.getActions()).filter(a -> a.getAction().equals(action)).findFirst()).isPresent()) {
            return mcrCollection;
        }
        String parentCollection = MCRURLRetriever.getParentCollection(collection);
        String string = defaultCollectionName = defaultCollection == null ? null : defaultCollection.getName();
        if (parentCollection == null) {
            LOGGER.debug("Using default collection '{}' for action: {}", (Object)defaultCollectionName, (Object)action);
            return defaultCollection;
        }
        LOGGER.debug("Checking parent collection '{}' for action: {}", (Object)parentCollection, (Object)action);
        MCRCollection collectionWithAction = MCRURLRetriever.getCollectionWithAction(parentCollection, action, defaultCollection);
        if (collectionWithAction == null) {
            LOGGER.debug("Using default collection '{}' for action: {}", (Object)defaultCollectionName, (Object)action);
            return defaultCollection;
        }
        if (mcrCollection == null) {
            mcrCollection = new MCRCollection();
            mcrCollection.setName(collection);
            mcrCollection.setActions(new MCRAction[0]);
        }
        for (MCRAction act : collectionWithAction.getActions()) {
            if (!act.getAction().equals(action)) continue;
            int oldLength = mcrCollection.getActions().length;
            mcrCollection.setActions(Arrays.copyOf(mcrCollection.getActions(), oldLength + 1));
            mcrCollection.getActions()[oldLength] = act;
        }
        COLLECTION_MAP.put(collection, mcrCollection);
        return mcrCollection;
    }

    private static String getParentCollection(String collection) {
        MCRCategoryID categoryId = new MCRCategoryID(MCRConstants.COLLECTION_CLASS_ID.getRootID(), collection);
        List parents = CATEGORY_DAO.getParents(categoryId);
        if (parents == null || parents.isEmpty()) {
            return null;
        }
        return ((MCRCategory)parents.iterator().next()).getId().getID();
    }
}

