/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wfc.actionmapping;

import org.jdom2.Element;
import org.mycore.access.mcrimpl.MCRRuleParser;
import org.mycore.datamodel.classifications2.MCRCategoryID;
import org.mycore.parsers.bool.MCRCondition;
import org.mycore.parsers.bool.MCRParseException;
import org.mycore.wfc.MCRConstants;
import org.mycore.wfc.actionmapping.MCRCategoryCondition;

public class MCRWorkflowRuleParser
extends MCRRuleParser {
    private static final String EQUALS = "=";
    private static final String EQUALS_NOT = "!=";
    private static final String STATUS = "status";
    private MCRCategoryID statusClassId = MCRConstants.STATUS_CLASS_ID;

    protected MCRWorkflowRuleParser() {
    }

    protected MCRCondition<?> parseElement(Element e) {
        String field = e.getAttributeValue("field");
        String operator = e.getAttributeValue("operator");
        String value = e.getAttributeValue("value");
        boolean not = EQUALS_NOT.equals(operator);
        if (STATUS.equals(field)) {
            return new MCRCategoryCondition(STATUS, new MCRCategoryID(this.statusClassId.getRootID(), value), not);
        }
        return super.parseElement(e);
    }

    protected MCRCondition<?> parseString(String s) {
        if (s.startsWith(STATUS)) {
            String value;
            boolean not;
            if ((s = s.substring(STATUS.length()).trim()).startsWith(EQUALS_NOT)) {
                not = true;
                value = s.substring(EQUALS_NOT.length()).trim();
            } else if (s.startsWith(EQUALS)) {
                not = false;
                value = s.substring(EQUALS.length()).trim();
            } else {
                throw new MCRParseException("syntax error: " + s);
            }
            return new MCRCategoryCondition(STATUS, new MCRCategoryID(this.statusClassId.getRootID(), value), not);
        }
        return super.parseString(s);
    }
}

