/*
 * Decompiled with CFR 0.152.
 */
package org.mycore.wfc.mail;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Document;
import org.mycore.common.MCRMailer;
import org.mycore.common.content.MCRContent;
import org.mycore.common.content.MCRJDOMContent;
import org.mycore.common.events.MCREvent;
import org.mycore.common.events.MCREventHandlerBase;
import org.mycore.datamodel.classifications2.MCRCategory;
import org.mycore.datamodel.classifications2.utils.MCRCategoryTransformer;
import org.mycore.datamodel.metadata.MCRDerivate;
import org.mycore.datamodel.metadata.MCRObject;
import org.mycore.datamodel.niofs.MCRPath;
import org.mycore.datamodel.niofs.MCRPathXML;

public class MCRMailEventHandler
extends MCREventHandlerBase {
    private static final Logger LOGGER = LogManager.getLogger(MCRMailEventHandler.class);

    private void sendNotificationMail(MCREvent evt, MCRContent doc, String description) throws Exception {
        LOGGER.info("Preparing mail for: {}", (Object)description);
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry entry : evt.entrySet()) {
            parameters.put((String)entry.getKey(), entry.getValue().toString());
        }
        parameters.put("action", evt.getEventType());
        parameters.put("type", evt.getObjectType());
        MCRMailer.sendMail((Document)doc.asXML(), (String)"e-mail-events", parameters);
    }

    private void handleCategoryEvent(MCREvent evt, MCRCategory obj) {
        MCRJDOMContent xml = new MCRJDOMContent(MCRCategoryTransformer.getMetaDataDocument((MCRCategory)obj, (boolean)false));
        this.handleEvent(evt, (MCRContent)xml, obj.toString());
    }

    private void handleObjectEvent(MCREvent evt, MCRObject obj) {
        MCRJDOMContent xml = new MCRJDOMContent(obj.createXML());
        this.handleEvent(evt, (MCRContent)xml, obj.getId().toString());
    }

    private void handleDerivateEvent(MCREvent evt, MCRDerivate der) {
        MCRJDOMContent xml = new MCRJDOMContent(der.createXML());
        this.handleEvent(evt, (MCRContent)xml, der.getId().toString());
    }

    private void handlePathEvent(MCREvent evt, Path file, BasicFileAttributes attrs) {
        if (!(file instanceof MCRPath)) {
            return;
        }
        MCRPath path = MCRPath.toMCRPath((Path)file);
        try {
            MCRJDOMContent xml = new MCRJDOMContent(MCRPathXML.getFileXML((MCRPath)path, (BasicFileAttributes)attrs));
            this.handleEvent(evt, (MCRContent)xml, path.toString());
        }
        catch (IOException e) {
            LOGGER.error("Error while generating mail for {}", (Object)file, (Object)e);
        }
    }

    private void handleEvent(MCREvent evt, MCRContent xml, String description) {
        try {
            this.sendNotificationMail(evt, xml, description);
        }
        catch (Exception e) {
            LOGGER.error("Error while handling event: {}", (Object)evt, (Object)e);
        }
    }

    protected void handleClassificationCreated(MCREvent evt, MCRCategory obj) {
        this.handleCategoryEvent(evt, obj);
    }

    protected void handleClassificationUpdated(MCREvent evt, MCRCategory obj) {
        this.handleCategoryEvent(evt, obj);
    }

    protected void handleClassificationDeleted(MCREvent evt, MCRCategory obj) {
        this.handleCategoryEvent(evt, obj);
    }

    protected void handleObjectCreated(MCREvent evt, MCRObject obj) {
        this.handleObjectEvent(evt, obj);
    }

    protected void handleObjectUpdated(MCREvent evt, MCRObject obj) {
        this.handleObjectEvent(evt, obj);
    }

    protected void handleObjectDeleted(MCREvent evt, MCRObject obj) {
        this.handleObjectEvent(evt, obj);
    }

    protected void handleDerivateCreated(MCREvent evt, MCRDerivate der) {
        this.handleDerivateEvent(evt, der);
    }

    protected void handleDerivateUpdated(MCREvent evt, MCRDerivate der) {
        this.handleDerivateEvent(evt, der);
    }

    protected void handleDerivateDeleted(MCREvent evt, MCRDerivate der) {
        this.handleDerivateEvent(evt, der);
    }

    protected void handlePathCreated(MCREvent evt, Path file, BasicFileAttributes attrs) {
        this.handlePathEvent(evt, file, attrs);
    }

    protected void handlePathUpdated(MCREvent evt, Path file, BasicFileAttributes attrs) {
        this.handlePathEvent(evt, file, attrs);
    }

    protected void handlePathDeleted(MCREvent evt, Path file, BasicFileAttributes attrs) {
        this.handlePathEvent(evt, file, attrs);
    }
}

