/*
 * Copyright (C) 2012-2015 by it's authors.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.n52.matlab.connector;

/**
 * Represents an exception returned by MATLAB during function execution.
 *
 * @author Richard Jones
 *
 */
public class MatlabException extends Exception implements MatlabResponse {

    private static final long serialVersionUID = 1L;
    private long id = -1;

    /**
     * Creates a new <code>MLException</code> instance with the given message.
     *
     * @param message the exception message
     */
    public MatlabException(String message) {
        super(message);
    }

    public MatlabException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

}
