/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.applib.AbstractFactoryAndRepository;
import org.nakedobjects.applib.DomainObjectContainer;
import org.nakedobjects.applib.TestDomainObject;

public class FactoryAndRepositoryTest {
    private DomainObjectContainer container;
    private AbstractFactoryAndRepository object;
    private Mockery context;

    @Before
    public void setUp() throws Exception {
        this.context = new Mockery();
        this.container = (DomainObjectContainer)this.context.mock(DomainObjectContainer.class);
        this.object = new AbstractFactoryAndRepository(){};
        this.object.setContainer(this.container);
    }

    @Test
    public void testContainer() throws Exception {
        Assert.assertEquals((Object)this.container, (Object)this.object.getContainer());
    }

    @Test
    public void testInformUser() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DomainObjectContainer)this.one(FactoryAndRepositoryTest.this.container)).informUser("message");
            }
        });
        this.object.informUser("message");
        this.context.assertIsSatisfied();
    }

    @Test
    public void testWarnUser() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DomainObjectContainer)this.one(FactoryAndRepositoryTest.this.container)).warnUser("message");
            }
        });
        this.object.warnUser("message");
        this.context.assertIsSatisfied();
    }

    @Test
    public void testRaiseError() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DomainObjectContainer)this.one(FactoryAndRepositoryTest.this.container)).raiseError("message");
            }
        });
        this.object.raiseError("message");
        this.context.assertIsSatisfied();
    }

    @Test
    public void testAllInstances() throws Exception {
        final ArrayList<TestDomainObject> list = new ArrayList<TestDomainObject>();
        list.add(new TestDomainObject());
        list.add(new TestDomainObject());
        list.add(new TestDomainObject());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DomainObjectContainer)this.one(FactoryAndRepositoryTest.this.container)).allInstances(TestDomainObject.class);
                this.will(5.returnValue((Object)list));
            }
        });
        List allInstances = this.object.allInstances(TestDomainObject.class);
        Assert.assertThat((Object)allInstances.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat(allInstances.get(0), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat(allInstances.get(0), (Matcher)CoreMatchers.equalTo(list.get(0)));
        Assert.assertThat(allInstances.get(1), (Matcher)CoreMatchers.equalTo(list.get(1)));
        Assert.assertThat(allInstances.get(2), (Matcher)CoreMatchers.equalTo(list.get(2)));
        this.context.assertIsSatisfied();
    }
}

