/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.util;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.applib.util.ReasonBuffer;

public class ReasonStringTest {
    private ReasonBuffer reason;

    @Before
    public void setUp() {
        this.reason = new ReasonBuffer();
    }

    @Test
    public void testNoReasonReturnsNull() throws Exception {
        Assert.assertEquals(null, (Object)this.reason.getReason());
    }

    @Test
    public void testAReasonReturnsString() throws Exception {
        this.reason.append("reason 1");
        Assert.assertEquals((Object)"reason 1", (Object)this.reason.getReason());
    }

    @Test
    public void testConditionalAppendWithTrue() {
        this.reason.appendOnCondition(true, "reason 1");
        Assert.assertEquals((Object)"reason 1", (Object)this.reason.getReason());
    }

    @Test
    public void testConditionalAppendWithFalse() {
        this.reason.appendOnCondition(false, "reason 1");
        Assert.assertEquals(null, (Object)this.reason.getReason());
    }

    @Test
    public void testAppendTwoReasons() {
        this.reason.append("reason 1");
        this.reason.append("reason 2");
        Assert.assertEquals((Object)"reason 1; reason 2", (Object)this.reason.getReason());
    }
}

