/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.authorization;

import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.plugins.hibernate.objectstore.util.HibernateUtil;
import org.nakedobjects.runtime.authorization.standard.Authorizor;

public class DatabaseAuthorizor
implements Authorizor {
    private static final Logger LOG = Logger.getLogger(DatabaseAuthorizor.class);
    private final boolean learn;
    private static final String AUTH_LEARN = "nakedobjects.security.learn";
    private static final int READ_WRITE = 0;
    private static final int READ_ONLY = 1;
    private static final String NO_FLAG_MATCH = "select count(p.permission) from permissions p, role r where p.role = r.id  and r.rolename = ? and p.permission = ?";
    private static final String FLAG_MATCH = "select count(p.permission) from permissions p, role r where p.role = r.id  and r.rolename = ? and p.permission = ? and p.flags is NULL or p.flags = ?";
    private static final String NO_FLAG_INSERT = "insert into permissions values (?, ?, ?)";
    private static final String FLAG_INSERT = "insert into permissions values (?, ?, ?, ?)";

    public DatabaseAuthorizor(NakedObjectConfiguration configuration) {
        this.learn = configuration.getBoolean(AUTH_LEARN, false);
    }

    public void init() {
    }

    private int getNextId() {
        try {
            HibernateUtil.startTransaction();
            SQLQuery sq = HibernateUtil.getCurrentSession().createSQLQuery("select id from permissions order by id desc limit 1");
            Integer id = (Integer)sq.uniqueResult();
            HibernateUtil.commitTransaction();
            return id != null ? id + 1 : 0;
        }
        catch (Exception e) {
            HibernateUtil.rollbackTransaction();
            throw new NakedObjectException((Throwable)e);
        }
    }

    private int getRoleId(String role) {
        try {
            HibernateUtil.startTransaction();
            SQLQuery sq = HibernateUtil.getCurrentSession().createSQLQuery("select id from role  where rolename = ?");
            sq.setString(0, role);
            Integer id = (Integer)sq.uniqueResult();
            HibernateUtil.commitTransaction();
            return id;
        }
        catch (Exception e) {
            HibernateUtil.rollbackTransaction();
            throw new NakedObjectException((Throwable)e);
        }
    }

    private boolean learn(String role, String key, Integer flag) {
        if (this.isMatch(role, key, flag)) {
            return true;
        }
        try {
            int permissionId = this.getNextId();
            int roleId = this.getRoleId(role);
            HibernateUtil.startTransaction();
            SQLQuery sq = HibernateUtil.getCurrentSession().createSQLQuery(flag == null ? NO_FLAG_INSERT : FLAG_INSERT);
            sq.setInteger(0, permissionId);
            sq.setInteger(1, roleId);
            sq.setString(2, key);
            if (flag != null) {
                sq.setInteger(3, flag.intValue());
            }
            sq.executeUpdate();
            HibernateUtil.commitTransaction();
        }
        catch (Exception e) {
            HibernateUtil.rollbackTransaction();
            throw new NakedObjectException((Throwable)e);
        }
        return true;
    }

    private boolean isMatch(String role, String key, Integer flag) {
        try {
            HibernateUtil.startTransaction();
            SQLQuery sq = HibernateUtil.getCurrentSession().createSQLQuery(flag == null ? NO_FLAG_MATCH : FLAG_MATCH);
            sq.setString(0, role);
            sq.setString(1, key);
            if (flag != null) {
                sq.setInteger(2, flag.intValue());
            }
            Number count = (Number)sq.uniqueResult();
            HibernateUtil.commitTransaction();
            return count != null && count.intValue() > 0;
        }
        catch (Exception e) {
            HibernateUtil.rollbackTransaction();
            throw new NakedObjectException((Throwable)e);
        }
    }

    public void shutdown() {
    }

    public boolean isAuthorised(String role, Identifier member, Integer flag) {
        if (this.learn) {
            return this.learn(role, member.toIdentityString(2), flag);
        }
        for (int depth = 0; depth <= 2; ++depth) {
            if (!this.isMatch(role, member.toIdentityString(depth), flag)) continue;
            return true;
        }
        return false;
    }

    public boolean isUsable(String role, Identifier member) {
        return this.isAuthorised(role, member, 0);
    }

    public boolean isVisible(String role, Identifier member) {
        return this.isAuthorised(role, member, null);
    }
}

