/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.algorithm;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.util.CallbackUtils;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.PersistAlgorithmAbstract;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.ToPersistObjectSet;

public class TwoPassPersistAlgorithm
extends PersistAlgorithmAbstract {
    private static final Logger LOG = Logger.getLogger(TwoPassPersistAlgorithm.class);

    public String name() {
        return "Two pass,  bottom up persistence walker";
    }

    public void makePersistent(NakedObject object, ToPersistObjectSet toPersistObjectSet) {
        if (object.getSpecification().isCollection()) {
            this.makeCollectionPersistent(object, toPersistObjectSet);
        } else {
            this.makeObjectPersistent(object, toPersistObjectSet);
        }
    }

    private void makeObjectPersistent(NakedObject adapter, ToPersistObjectSet toPersistObjectSet) {
        int i;
        if (this.alreadyPersistedOrNotPersistableOrServiceOrStandalone(adapter)) {
            return;
        }
        if (adapter.isPersistent()) {
            return;
        }
        LOG.info((Object)("persist " + adapter));
        CallbackUtils.callCallback((NakedObject)adapter, PersistingCallbackFacet.class);
        adapter.changeState(ResolveState.RESOLVED);
        adapter.changeState(ResolveState.UPDATING);
        toPersistObjectSet.addPersistedObject(adapter);
        NakedObjectAssociation[] fields = adapter.getSpecification().getAssociations();
        for (i = 0; i < fields.length; ++i) {
            NakedObjectAssociation association = fields[i];
            if (!association.isPersisted() || association.isOneToManyAssociation()) continue;
            this.processOneToOneAssociation(adapter, toPersistObjectSet, association);
        }
        for (i = 0; i < fields.length; ++i) {
            NakedObjectAssociation field = fields[i];
            if (!field.isPersisted() || !field.isOneToManyAssociation()) continue;
            this.processOneToManyAssociation(adapter, toPersistObjectSet, field);
        }
        CallbackUtils.callCallback((NakedObject)adapter, PersistedCallbackFacet.class);
    }

    private void processOneToOneAssociation(NakedObject object, ToPersistObjectSet toPersistObjectSet, NakedObjectAssociation association) {
        NakedObject fieldValue = association.get(object);
        if (fieldValue != null) {
            if (!(fieldValue instanceof NakedObject)) {
                throw new NakedObjectException();
            }
            this.makePersistent(fieldValue, toPersistObjectSet);
        }
    }

    private void processOneToManyAssociation(NakedObject object, ToPersistObjectSet toPersistObjectSet, NakedObjectAssociation field) {
        NakedObject collection = field.get(object);
        this.makePersistent(collection, toPersistObjectSet);
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        for (NakedObject adapter : facet.iterable(collection)) {
            this.makePersistent(adapter, toPersistObjectSet);
        }
    }

    private void makeCollectionPersistent(NakedObject collection, ToPersistObjectSet toPersistObjectSet) {
        if (this.alreadyPersistedOrNotPersistable(collection)) {
            return;
        }
        LOG.info((Object)("persist " + collection));
        if (collection.getResolveState() == ResolveState.TRANSIENT) {
            collection.changeState(ResolveState.RESOLVED);
        }
        toPersistObjectSet.madePersistent(collection);
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        for (NakedObject adapter : facet.iterable(collection)) {
            this.makePersistent(adapter, toPersistObjectSet);
        }
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        return toString.toString();
    }
}

