/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.listener;

import org.apache.log4j.Logger;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.tuple.StandardProperty;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.AggregatedOid;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.listener.NakedEventListenerAbstract;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator.HibernateOid;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.ToPersistObjectSet;

public class NakedInsertPostEventListener
extends NakedEventListenerAbstract
implements PostInsertEventListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(NakedInsertPostEventListener.class);

    public void onPostInsert(PostInsertEvent event) {
        Object entity;
        NakedObject adapter;
        HibernateOid oid;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PostInsertEvent " + this.logString(event)));
        }
        if (!(oid = (HibernateOid)(adapter = this.getAdapterFor(entity = event.getEntity())).getOid()).isTransient()) {
            throw new NakedObjectException("Not transient: oid=" + oid + "," + " resolve state=" + adapter.getResolveState() + " for " + entity);
        }
        this.replaceCollections(adapter, event);
        oid.setHibernateId(event.getId());
        oid.makePersistent();
        if (this.getPersistenceSession() instanceof ToPersistObjectSet) {
            ToPersistObjectSet persistedObjectAdder = (ToPersistObjectSet)this.getPersistenceSession();
            persistedObjectAdder.madePersistent(adapter);
        }
        this.clearDirtyFor(adapter);
    }

    private void replaceCollections(NakedObject parent, PostInsertEvent event) {
        NakedObjectAssociation[] nofAssociations = parent.getSpecification().getAssociations();
        StandardProperty[] hibProperties = event.getPersister().getEntityMetamodel().getProperties();
        Object[] hibCollections = event.getState();
        for (int i = 0; i < nofAssociations.length; ++i) {
            if (!nofAssociations[i].isOneToManyAssociation()) continue;
            String nofCollectionId = nofAssociations[i].getId();
            this.replaceCollection(parent, hibProperties, hibCollections, nofCollectionId);
        }
    }

    private void replaceCollection(NakedObject parent, StandardProperty[] hibProperties, Object[] hibPropertyObjects, String nofCollectionId) {
        Oid parentOid = parent.getOid();
        for (int j = 0; j < hibProperties.length; ++j) {
            String hibPropertyName = hibProperties[j].getName();
            if (!hibPropertyName.equals(nofCollectionId)) continue;
            Object hibCollectionObject = hibPropertyObjects[j];
            AggregatedOid collectionOid = new AggregatedOid(parentOid, nofCollectionId);
            NakedObject collectionAdapter = this.getAdapterFor(collectionOid);
            collectionAdapter.replacePojo(hibCollectionObject);
            break;
        }
    }

    private String logString(PostInsertEvent event) {
        return event.getEntity().getClass() + " " + event.getId();
    }
}

