/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.listener;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import org.apache.log4j.Logger;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.event.LoadEvent;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.def.DefaultLoadEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator.HibernateOid;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionHydrator;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NakedLoadEventListener
extends DefaultLoadEventListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(NakedLoadEventListener.class);

    public void onLoad(LoadEvent event, LoadEventListener.LoadType loadType) throws HibernateException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("LoadEvent - pre onLoad type=" + event.getEntityClassName() + ", " + "id=" + event.getEntityId() + ", " + "result=" + (event.getResult() == null ? "null" : event.getResult().getClass().getName()) + ", " + "instancetoload=" + event.getInstanceToLoad()));
        }
        super.onLoad(event, loadType);
    }

    protected Object proxyOrLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        Class cls;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("loading entity: " + MessageHelper.infoString((EntityPersister)persister, (Object)event.getEntityId(), (SessionFactoryImplementor)event.getSession().getFactory())));
        }
        if (!persister.hasProxy()) {
            return this.load(event, persister, keyToLoad, options);
        }
        PersistenceContext persistenceContext = event.getSession().getPersistenceContext();
        Assert.assertNull((Object)persistenceContext.getProxy(keyToLoad));
        if (options.isAllowProxyCreation() && this.classIsInstantiable(cls = persister.getMappedClass(EntityMode.POJO))) {
            return this.loadUnresolvedObject(event, persister, keyToLoad, options, persistenceContext);
        }
        return this.load(event, persister, keyToLoad, options);
    }

    private boolean classIsInstantiable(Class<?> cls) {
        int clsModifiers = cls.getModifiers();
        return !Modifier.isAbstract(clsModifiers) && !Modifier.isInterface(cls.getModifiers());
    }

    private Object loadUnresolvedObject(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, PersistenceContext persistenceContext) {
        Serializable entityId = event.getEntityId();
        HibernateOid oid = HibernateOid.createPersistent(event.getEntityClassName(), entityId);
        NakedObjectSpecification spec = this.getSpecificationLoader().loadSpecification(event.getEntityClassName());
        NakedObject nakedObject = this.getAdapterManager().getAdapterFor((Oid)oid);
        if (nakedObject == null) {
            nakedObject = this.getHydrator().recreateAdapter((Oid)oid, spec);
            Assert.assertFalse((boolean)persistenceContext.isEntryFor(nakedObject.getObject()));
            return nakedObject.getObject();
        }
        return this.load(event, persister, keyToLoad, options);
    }

    protected SpecificationLoader getSpecificationLoader() {
        return NakedObjectsContext.getSpecificationLoader();
    }

    protected PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private PersistenceSessionHydrator getHydrator() {
        return this.getPersistenceSession();
    }

    private AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }
}

