/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.nanoframework.commons.support.logging.Logger;
import org.nanoframework.commons.support.logging.LoggerFactory;
import org.nanoframework.commons.util.CollectionUtils;
import org.nanoframework.commons.util.SerializableUtils;
import org.nanoframework.commons.util.StringUtils;
import org.nanoframework.orm.jedis.GlobalRedisClient;
import org.nanoframework.orm.jedis.RedisClient;

public class RedisCache<K, V>
implements Cache<K, V> {
    private Logger LOG = LoggerFactory.getLogger(RedisCache.class);
    private final String redisSourceNames;
    private Map<String, RedisClient> sessions;
    private final String cacheName;

    public RedisCache(String redisSourceNames, String cacheName) {
        this.redisSourceNames = redisSourceNames;
        this.cacheName = cacheName;
        if (StringUtils.isBlank((CharSequence)redisSourceNames)) {
            throw new IllegalArgumentException("redisSourceNames must be not blank.");
        }
        if (StringUtils.isBlank((CharSequence)cacheName)) {
            throw new IllegalArgumentException("cacheName must be not blank.");
        }
    }

    public V get(K key) throws CacheException {
        this.initRedisClient();
        for (Map.Entry<String, RedisClient> item : this.sessions.entrySet()) {
            try {
                RedisClient client = item.getValue();
                return (V)SerializableUtils.decode((String)client.hget(this.cacheName, SerializableUtils.encode(key)));
            }
            catch (Exception e) {
                this.LOG.error("\u8bfb\u53d6Cache\u5f02\u5e38[get()][{}]: {}", new Object[]{item.getKey(), e.getMessage()});
            }
        }
        return null;
    }

    public V put(K key, V value) throws CacheException {
        this.initRedisClient();
        RedisClient client = this.sessions.values().iterator().next();
        client.hset(this.cacheName, SerializableUtils.encode(key), SerializableUtils.encode(value));
        return value;
    }

    public V remove(K key) throws CacheException {
        this.initRedisClient();
        RedisClient client = this.sessions.values().iterator().next();
        String val = client.hget(this.cacheName, SerializableUtils.encode(key));
        if (!StringUtils.isEmpty((CharSequence)val)) {
            client.hdel(this.cacheName, new String[]{SerializableUtils.encode(key)});
            return (V)SerializableUtils.decode((String)val);
        }
        return null;
    }

    public void clear() throws CacheException {
        this.initRedisClient();
        RedisClient client = this.sessions.values().iterator().next();
        client.del(new String[]{this.cacheName});
    }

    public int size() {
        this.initRedisClient();
        for (Map.Entry<String, RedisClient> item : this.sessions.entrySet()) {
            try {
                RedisClient client = item.getValue();
                Long len = client.hlen(this.cacheName);
                return len.intValue();
            }
            catch (Exception e) {
                this.LOG.error("\u8bfb\u53d6Cache\u5f02\u5e38[size()][{}]: {}", new Object[]{item.getKey(), e.getMessage()});
            }
        }
        return 0;
    }

    public Set<K> keys() {
        this.initRedisClient();
        for (Map.Entry<String, RedisClient> item : this.sessions.entrySet()) {
            try {
                RedisClient client = item.getValue();
                Set keys = client.hkeys(this.cacheName);
                if (CollectionUtils.isEmpty((Collection)keys)) continue;
                LinkedHashSet sets = Sets.newLinkedHashSet();
                keys.forEach(key -> sets.add(SerializableUtils.decode((String)key)));
                return sets;
            }
            catch (Exception e) {
                this.LOG.error("\u8bfb\u53d6Cache\u5f02\u5e38[keys()][" + item.getKey() + "]: " + e.getMessage());
            }
        }
        return Collections.emptySet();
    }

    public Collection<V> values() {
        this.initRedisClient();
        for (Map.Entry<String, RedisClient> item : this.sessions.entrySet()) {
            try {
                RedisClient client = item.getValue();
                List vals = client.hvals(this.cacheName);
                if (CollectionUtils.isEmpty((Collection)vals)) continue;
                ArrayList lists = Lists.newArrayList();
                vals.forEach(val -> lists.add(SerializableUtils.decode((String)val)));
                return lists;
            }
            catch (Exception e) {
                this.LOG.error("\u8bfb\u53d6Cache\u5f02\u5e38[values()][" + item.getKey() + "]: " + e.getMessage());
            }
        }
        return Collections.emptyList();
    }

    public void setSessions(String redisSourceNames) {
        if (StringUtils.isNotBlank((CharSequence)redisSourceNames)) {
            String[] names = redisSourceNames.split(",");
            LinkedHashMap sessionMap = Maps.newLinkedHashMap();
            for (String name : names) {
                RedisClient client;
                if (StringUtils.isBlank((CharSequence)name) || (client = GlobalRedisClient.get((String)name)) == null) continue;
                sessionMap.put(name, client);
            }
            this.sessions = sessionMap;
        }
    }

    private void initRedisClient() {
        if (CollectionUtils.isEmpty(this.sessions)) {
            this.setSessions(this.redisSourceNames);
        }
    }
}

