/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.listener;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionListenerAdapter;
import org.nanoframework.commons.support.logging.Logger;
import org.nanoframework.commons.support.logging.LoggerFactory;
import org.nanoframework.commons.util.CollectionUtils;
import org.nanoframework.extension.shiro.web.component.SSOComponent;
import org.nanoframework.orm.jedis.RedisClient;

public class SSOSessionListener
extends SessionListenerAdapter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SSOSessionListener.class);

    public void onStop(Session session) {
        this.unbindSession((String)((Object)session.getId()));
    }

    public void onExpiration(Session session) {
        this.unbindSession((String)((Object)session.getId()));
    }

    protected void unbindSession(String sessionId) {
        int errorRetry = SSOComponent.ERROR_RETRY;
        for (int count = 0; count < errorRetry; ++count) {
            try {
                this.unbindSession0(sessionId);
                return;
            }
            catch (Throwable e) {
                LOGGER.error("unbindSession Error: {}, retry {}...", new Object[]{e.getMessage(), count + 1});
                continue;
            }
        }
    }

    protected void unbindSession0(String sessionId) {
        String shiroSessionListenerPrefix = SSOComponent.SHIRO_SESSION_LISTENER_PREFIX;
        String shiroClientSessionPrefix = SSOComponent.SHIRO_CLIENT_SESSION_PREFIX;
        RedisClient shiro = SSOComponent.SHIRO;
        String sessionListenerKey = shiroSessionListenerPrefix + sessionId;
        Set clientSessionIds = shiro.smembers(sessionListenerKey);
        if (!CollectionUtils.isEmpty((Collection)clientSessionIds)) {
            ArrayList delKeys = Lists.newArrayList();
            clientSessionIds.forEach(clientSessionId -> delKeys.add(shiroClientSessionPrefix + clientSessionId));
            delKeys.add(sessionListenerKey);
            shiro.del((List)delKeys);
        }
    }
}

