/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.realm;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.jdbc.JdbcRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.nanoframework.commons.util.StringUtils;
import org.nanoframework.extension.shiro.realm.RealmQuery;
import org.nanoframework.orm.jdbc.binding.GlobalJdbcManager;

public class JdbcRealm
extends org.apache.shiro.realm.jdbc.JdbcRealm {
    protected String dataSourceName;
    protected RealmQuery realmQuery;

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
        this.dataSource = GlobalJdbcManager.get((String)dataSourceName).getDataSource();
    }

    public void setRealmQuery(RealmQuery realmQuery) {
        this.realmQuery = realmQuery;
        if (StringUtils.isNotBlank((CharSequence)realmQuery.getAuthenticationQuery())) {
            this.setAuthenticationQuery(realmQuery.getAuthenticationQuery());
        }
        if (StringUtils.isNotBlank((CharSequence)realmQuery.getUserRolesQuery())) {
            this.setUserRolesQuery(realmQuery.getUserRolesQuery());
        }
        if (StringUtils.isNotBlank((CharSequence)realmQuery.getPermissionsQuery())) {
            this.setPermissionsQuery(realmQuery.getPermissionsQuery());
        }
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        if (this.dataSource == null) {
            this.dataSource = GlobalJdbcManager.get((String)this.dataSourceName).getDataSource();
        }
        return super.doGetAuthenticationInfo(token);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        if (this.dataSource == null) {
            this.dataSource = GlobalJdbcManager.get((String)this.dataSourceName).getDataSource();
        }
        return super.doGetAuthorizationInfo(principals);
    }

    protected String getSaltForUser(String username) {
        return "Nano Framework Extension Shiro Salt for user: [" + username + ']';
    }

    public void setSaltStyle(String saltStyle) {
        this.saltStyle = JdbcRealm.SaltStyle.valueOf((String)saltStyle);
        if (this.saltStyle == JdbcRealm.SaltStyle.COLUMN && this.authenticationQuery.equals("select password from users where username = ?")) {
            this.authenticationQuery = "select password, password_salt from users where username = ?";
        }
    }

    public AuthorizationInfo getAuthorizationInfo(PrincipalCollection principals) {
        return super.getAuthorizationInfo(principals);
    }
}

