/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.realm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.apache.shiro.util.JdbcUtils;
import org.nanoframework.commons.support.logging.Logger;
import org.nanoframework.commons.support.logging.LoggerFactory;
import org.nanoframework.extension.shiro.realm.JdbcRealm;
import org.nanoframework.orm.mybatis.GlobalSqlSession;

public class MyBatisRealm
extends JdbcRealm {
    private Logger LOGGER = LoggerFactory.getLogger(MyBatisRealm.class);
    protected SqlSessionManager sqlSessionManager;

    @Override
    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
        this.sqlSessionManager = GlobalSqlSession.get((String)dataSourceName);
    }

    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        String username = upToken.getUsername();
        if (username == null) {
            throw new AccountException("Null usernames are not allowed by this realm.");
        }
        SqlSession sqlSession = null;
        Connection conn = null;
        SimpleAuthenticationInfo info = null;
        try {
            if (this.sqlSessionManager == null) {
                this.sqlSessionManager = GlobalSqlSession.get((String)this.dataSourceName);
            }
            sqlSession = this.sqlSessionManager.openSession();
            conn = sqlSession.getConnection();
            String password = null;
            String salt = null;
            switch (this.saltStyle) {
                case NO_SALT: {
                    password = this.getPasswordForUser(conn, username)[0];
                    break;
                }
                case CRYPT: {
                    throw new ConfigurationException("Not implemented yet");
                }
                case COLUMN: {
                    String[] queryResults = this.getPasswordForUser(conn, username);
                    password = queryResults[0];
                    salt = queryResults[1];
                    break;
                }
                case EXTERNAL: {
                    password = this.getPasswordForUser(conn, username)[0];
                    salt = this.getSaltForUser(username);
                }
            }
            if (password == null) {
                throw new UnknownAccountException("No account found for user [" + username + ']');
            }
            info = new SimpleAuthenticationInfo((Object)username, (Object)password.toCharArray(), this.getName());
            if (salt != null) {
                info.setCredentialsSalt(ByteSource.Util.bytes((String)salt));
            }
        }
        catch (SQLException e) {
            String message = "There was a SQL error while authenticating user [" + username + ']';
            this.LOGGER.error(message, (Throwable)e);
            throw new AuthenticationException(message, (Throwable)e);
        }
        finally {
            if (sqlSession != null) {
                sqlSession.close();
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getPasswordForUser(Connection conn, String username) throws SQLException {
        String[] result;
        boolean returningSeparatedSalt = false;
        switch (this.saltStyle) {
            case NO_SALT: 
            case CRYPT: 
            case EXTERNAL: {
                result = new String[1];
                break;
            }
            default: {
                result = new String[2];
                returningSeparatedSalt = true;
            }
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.authenticationQuery);
            ps.setString(1, username);
            rs = ps.executeQuery();
            boolean foundResult = false;
            while (rs.next()) {
                if (foundResult) {
                    throw new AuthenticationException("More than one user row found for user [" + username + "]. Usernames must be unique.");
                }
                result[0] = rs.getString(1);
                if (returningSeparatedSalt) {
                    result[1] = rs.getString(2);
                }
                foundResult = true;
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeStatement((Statement)ps);
            throw throwable;
        }
        JdbcUtils.closeResultSet((ResultSet)rs);
        JdbcUtils.closeStatement((Statement)ps);
        return result;
    }

    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        if (principals == null) {
            throw new AuthorizationException("PrincipalCollection method argument cannot be null.");
        }
        String username = (String)this.getAvailablePrincipal(principals);
        SqlSession sqlSession = null;
        Connection conn = null;
        Set roleNames = null;
        Set permissions = null;
        try {
            if (this.sqlSessionManager == null) {
                this.sqlSessionManager = GlobalSqlSession.get((String)this.dataSourceName);
            }
            sqlSession = this.sqlSessionManager.openSession();
            conn = sqlSession.getConnection();
            roleNames = this.getRoleNamesForUser(conn, username);
            if (this.permissionsLookupEnabled) {
                permissions = this.getPermissions(conn, username, roleNames);
            }
        }
        catch (SQLException e) {
            String message = "There was a SQL error while authorizing user [" + username + ']';
            this.LOGGER.error(message, (Throwable)e);
            throw new AuthorizationException(message, (Throwable)e);
        }
        finally {
            if (sqlSession != null) {
                sqlSession.close();
            }
        }
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo(roleNames);
        info.setStringPermissions(permissions);
        return info;
    }
}

