/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.session.mgt.eis;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.ValidatingSession;
import org.apache.shiro.session.mgt.eis.CachingSessionDAO;
import org.nanoframework.commons.support.logging.Logger;
import org.nanoframework.commons.support.logging.LoggerFactory;
import org.nanoframework.commons.util.CollectionUtils;
import org.nanoframework.commons.util.SerializableUtils;
import org.nanoframework.commons.util.StringUtils;
import org.nanoframework.orm.jedis.GlobalRedisClient;
import org.nanoframework.orm.jedis.RedisClient;

public class RedisSessionDAO
extends CachingSessionDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisSessionDAO.class);
    protected static final String DEFAULT_REDIS_SOURCE_NAME = "shiro";
    protected static final String DEFAULT_SESSION_NAME = "SHIRO_SESSION_";
    protected static final PersistType DEFAULT_PERSIST_TYPE = PersistType.SET;
    protected static final int DEFAULT_SESSION_EXPIRE = 1800;
    protected String redisSourceNames = "shiro";
    protected Map<String, RedisClient> sessions;
    protected String sessionName = "SHIRO_SESSION_";
    protected PersistType persistType = DEFAULT_PERSIST_TYPE;
    protected int sessionExpire = 1800;

    protected Serializable doCreate(Session session) {
        this.initRedisClient();
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        RedisClient client = this.sessions.values().iterator().next();
        switch (this.persistType) {
            case SET: {
                String id = this.sessionName + sessionId;
                client.set(id, SerializableUtils.encode((Object)session));
                client.expire(id, this.sessionExpire);
                break;
            }
            case HSET: {
                client.hset(this.sessionName, (String)((Object)sessionId), SerializableUtils.encode((Object)session));
            }
        }
        return session.getId();
    }

    protected void doUpdate(Session session) {
        if (session instanceof ValidatingSession && !((ValidatingSession)session).isValid()) {
            return;
        }
        this.initRedisClient();
        RedisClient client = this.sessions.values().iterator().next();
        switch (this.persistType) {
            case SET: {
                String id = this.sessionName + session.getId();
                client.set(id, SerializableUtils.encode((Object)session));
                client.expire(id, this.sessionExpire);
                break;
            }
            case HSET: {
                client.hset(this.sessionName, (String)((Object)session.getId()), SerializableUtils.encode((Object)session));
            }
        }
    }

    protected void doDelete(Session session) {
        this.initRedisClient();
        RedisClient client = this.sessions.values().iterator().next();
        switch (this.persistType) {
            case SET: {
                client.del(new String[]{this.sessionName + session.getId()});
                break;
            }
            case HSET: {
                client.hdel(this.sessionName, new String[]{JSON.toJSONString((Object)session.getId())});
            }
        }
    }

    protected Session doReadSession(Serializable sessionId) {
        this.initRedisClient();
        String value = null;
        for (Map.Entry<String, RedisClient> item : this.sessions.entrySet()) {
            try {
                RedisClient client = item.getValue();
                switch (this.persistType) {
                    case SET: {
                        value = client.get(this.sessionName + sessionId);
                        break;
                    }
                    case HSET: {
                        value = client.hget(this.sessionName, (String)((Object)sessionId));
                    }
                }
                break;
            }
            catch (Exception e) {
                LOGGER.error("\u8bfb\u53d6Session\u5f02\u5e38[" + item.getKey() + "]: " + e.getMessage());
            }
        }
        if (StringUtils.isNotBlank(value)) {
            return (Session)SerializableUtils.decode(value);
        }
        return null;
    }

    public Collection<Session> getActiveSessions() {
        return super.getActiveSessions();
    }

    public void setRedisSourceNames(String jedisSourceNames) {
        this.redisSourceNames = jedisSourceNames;
        if (StringUtils.isNotBlank((CharSequence)jedisSourceNames)) {
            String[] names = jedisSourceNames.split(",");
            LinkedHashMap sessionMap = Maps.newLinkedHashMap();
            for (String name : names) {
                RedisClient client;
                if (StringUtils.isBlank((CharSequence)name) || (client = GlobalRedisClient.get((String)name)) == null) continue;
                sessionMap.put(name, client);
            }
            this.sessions = sessionMap;
        }
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setPersistType(String persistType) {
        this.persistType = PersistType.valueOf(persistType);
    }

    public void setSessionExpire(int sessionExpire) {
        this.sessionExpire = sessionExpire;
    }

    private void initRedisClient() {
        if (CollectionUtils.isEmpty(this.sessions)) {
            this.setRedisSourceNames(this.redisSourceNames);
        }
    }

    protected static enum PersistType {
        SET,
        HSET;

    }
}

