/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.util;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import org.nanoframework.extension.shiro.util.SimpleByteSource;

public interface ByteSource
extends Serializable {
    public byte[] getBytes();

    public String toHex();

    public String toBase64();

    public boolean isEmpty();

    public static final class Util {
        public static ByteSource bytes(byte[] bytes) {
            return new SimpleByteSource(bytes);
        }

        public static ByteSource bytes(char[] chars) {
            return new SimpleByteSource(chars);
        }

        public static ByteSource bytes(String string) {
            return new SimpleByteSource(string);
        }

        public static ByteSource bytes(ByteSource source) {
            return new SimpleByteSource(source);
        }

        public static ByteSource bytes(File file) {
            return new SimpleByteSource(file);
        }

        public static ByteSource bytes(InputStream stream) {
            return new SimpleByteSource(stream);
        }

        public static boolean isCompatible(Object source) {
            return SimpleByteSource.isCompatible(source);
        }

        public static ByteSource bytes(Object source) throws IllegalArgumentException {
            if (source == null) {
                return null;
            }
            if (!Util.isCompatible(source)) {
                String msg = "Unable to heuristically acquire bytes for object of type [" + source.getClass().getName() + "].  If this type is indeed a byte-backed data type, you might want to write your own ByteSource implementation to extract its bytes explicitly.";
                throw new IllegalArgumentException(msg);
            }
            if (source instanceof byte[]) {
                return Util.bytes((byte[])source);
            }
            if (source instanceof ByteSource) {
                return (ByteSource)source;
            }
            if (source instanceof char[]) {
                return Util.bytes((char[])source);
            }
            if (source instanceof String) {
                return Util.bytes((String)source);
            }
            if (source instanceof File) {
                return Util.bytes((File)source);
            }
            if (source instanceof InputStream) {
                return Util.bytes((InputStream)source);
            }
            throw new IllegalStateException("Encountered unexpected byte source.  This is a bug - please notify the Shiro developer list asap (the isCompatible implementation does not reflect this method's implementation).");
        }
    }
}

