/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.util;

import java.util.Collection;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.nanoframework.commons.support.logging.Logger;
import org.nanoframework.commons.support.logging.LoggerFactory;
import org.nanoframework.commons.util.StringUtils;

public class ShiroSecurityHelper {
    private final Logger LOG = LoggerFactory.getLogger(ShiroSecurityHelper.class);
    private SessionDAO sessionDAO;

    public SessionDAO getSessionDAO() {
        if (this.sessionDAO == null) {
            this.sessionDAO = ((DefaultSessionManager)((DefaultSecurityManager)SecurityUtils.getSecurityManager()).getSessionManager()).getSessionDAO();
        }
        return this.sessionDAO;
    }

    public String getCurrentUsername() {
        Subject subject = this.getSubject();
        PrincipalCollection collection = subject.getPrincipals();
        if (null != collection && !collection.isEmpty()) {
            return (String)collection.iterator().next();
        }
        return null;
    }

    public Session getSession() {
        return SecurityUtils.getSubject().getSession();
    }

    public String getSessionId() {
        Session session = this.getSession();
        if (null == session) {
            return null;
        }
        return this.getSession().getId().toString();
    }

    public Session getSessionByUsername(String username) {
        Collection sessions = this.getSessionDAO().getActiveSessions();
        for (Session session : sessions) {
            if (null == session || !StringUtils.equals((CharSequence)String.valueOf(session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY)), (CharSequence)username)) continue;
            return session;
        }
        return null;
    }

    public boolean kickOutUser(String username) {
        Session session = this.getSessionByUsername(username);
        if (null != session && !StringUtils.equals((CharSequence)String.valueOf(session.getId()), (CharSequence)this.getSessionId())) {
            this.getSessionDAO().delete(session);
            this.LOG.info("Success kick out user {}", new Object[]{username});
            return true;
        }
        return false;
    }

    public boolean hasAuthenticated() {
        return this.getSubject().isAuthenticated();
    }

    private Subject getSubject() {
        return SecurityUtils.getSubject();
    }
}

