/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.web.component;

import com.google.inject.ImplementedBy;
import java.util.Map;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.nanoframework.core.component.stereotype.Component;
import org.nanoframework.core.component.stereotype.bind.PathVariable;
import org.nanoframework.core.component.stereotype.bind.RequestMapping;
import org.nanoframework.core.component.stereotype.bind.RequestMethod;
import org.nanoframework.core.component.stereotype.bind.RequestParam;
import org.nanoframework.extension.shiro.web.component.impl.SSOComponentImpl;
import org.nanoframework.orm.jedis.GlobalRedisClient;
import org.nanoframework.orm.jedis.RedisClient;
import org.nanoframework.web.server.http.status.ResultMap;
import org.nanoframework.web.server.mvc.View;

@Component
@ImplementedBy(value=SSOComponentImpl.class)
@RequestMapping(value="/sso/v1")
public interface SSOComponent {
    public static final String DEFAULT_SHIRO_REDIS_CLIENT_NAME = "shiro";
    public static final String DEFAULT_ERROR_RETRY = "3";
    public static final String DEFAULT_SHIRO_CLIENT_SESSION_PREFIX = "SHIRO_CLIENT_SESSION_";
    public static final String DEFAULT_SHIRO_SESSION_LISTENER_PREFIX = "SHIRO_SESSION_LISTENER_";
    public static final String SHIRO_REDIS_CLIENT_PROPERTY = "context.sso.shiro.client.redis.name";
    public static final String SHIRO_CLIENT_SESSION_PREFIX_PROPERTY = "context.sso.shiro.client.session.prefix";
    public static final String ERROR_RETRY_PROPERTY = "context.sso.error.retry";
    public static final String SHIRO_SESSION_LISTENER_PREFIX_PROPERTY = "context.sso.shiro.session.listener.prefix";
    public static final RedisClient SHIRO = GlobalRedisClient.get((String)System.getProperty("context.sso.shiro.client.redis.name", "shiro"));
    public static final String SHIRO_CLIENT_SESSION_PREFIX = System.getProperty("context.sso.shiro.client.session.prefix", "SHIRO_CLIENT_SESSION_");
    public static final int ERROR_RETRY = Integer.parseInt(System.getProperty("context.sso.error.retry", "3"));
    public static final String SHIRO_SESSION_LISTENER_PREFIX = System.getProperty("context.sso.shiro.session.listener.prefix", "SHIRO_SESSION_LISTENER_");

    @RequestMapping(value="/session/{clientSessionId}", method={RequestMethod.GET})
    public String getSession(@PathVariable(value="clientSessionId") String var1);

    @RequestMapping(value="/session/{clientSessionId}", method={RequestMethod.POST})
    public String registrySession(@PathVariable(value="clientSessionId") String var1, @RequestParam(value="ticket") String var2);

    @RequestMapping(value="/session/{clientSessionId}", method={RequestMethod.DELETE})
    public ResultMap removeSession(@PathVariable(value="clientSessionId") String var1);

    @RequestMapping(value="/session/{clientSessionId}/attribute", method={RequestMethod.POST})
    public ResultMap syncSessionAttribute(@PathVariable(value="clientSessionId") String var1, @RequestParam(value="attribute") String var2);

    @RequestMapping(value="/session/{clientSessionId}/max.inactive.internal", method={RequestMethod.POST})
    public ResultMap syncSessionMaxInactiveInternal(@PathVariable(value="clientSessionid") String var1, @RequestParam(value="max.inactive.internal") Integer var2);

    @RequestMapping(value="/session/bind", method={RequestMethod.GET})
    public View bindSession(@RequestParam(value="service") String var1, @RequestParam(value="sessionId") String var2);

    @RequestMapping(value="/login")
    public View loginFailure(@RequestParam(value="shiroLoginFailure", required=false) String var1, @RequestParam(value="service", required=false) String var2);

    @RequestMapping(value="/remote/login", method={RequestMethod.POST})
    public Map<String, Object> login(@RequestParam(value="token") UsernamePasswordToken var1, @RequestParam(value="service", required=false) String var2);

    @RequestMapping(value="/remote/logout", method={RequestMethod.GET})
    public ResultMap logout();

    @RequestMapping(value="/remote/logined", method={RequestMethod.GET})
    public Map<String, Object> isLogined(@RequestParam(value="service", required=false) String var1);
}

