/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.web.component.impl;

import com.google.inject.Inject;
import java.util.Date;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.ValidatingSession;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.nanoframework.commons.crypt.CryptUtil;
import org.nanoframework.commons.support.logging.Logger;
import org.nanoframework.commons.support.logging.LoggerFactory;
import org.nanoframework.commons.util.SerializableUtils;
import org.nanoframework.commons.util.StringUtils;
import org.nanoframework.extension.shiro.Protocol;
import org.nanoframework.extension.shiro.web.component.SSOComponent;
import org.nanoframework.extension.shiro.web.component.impl.SSOComponentImpl;
import org.nanoframework.extension.shiro.web.service.SSOService;
import org.nanoframework.web.server.filter.HttpRequestFilter;
import org.nanoframework.web.server.http.status.HttpStatus;
import org.nanoframework.web.server.http.status.ResultMap;
import org.nanoframework.web.server.mvc.Model;
import org.nanoframework.web.server.mvc.View;
import org.nanoframework.web.server.mvc.support.AngularRedirectView;
import org.nanoframework.web.server.mvc.support.ForwardView;
import org.nanoframework.web.server.mvc.support.RedirectView;

public abstract class AbstractSSOComponent
implements SSOComponent {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SSOComponentImpl.class);
    protected static final String DEFAULT_SHIRO_SESSION_PREFIX = "SHIRO_SESSION_";
    protected static final String DEFAULT_SHIRO_CLIENT_EXPIRE_TIME = "3600";
    protected static final String DEFAULT_SHIRO_SESSION_LISTENER_EXPIRE_TIME = "7200";
    protected static final String DEFAULT_IS_BIND_SESSION_FORWARD = "true";
    protected static final String DEFAULT_BIND_SESSION_FORWARD_URL = "/pages/login.jsp";
    protected static final String DEFAULT_BIND_SESSION_REDIRECT_URL = "";
    protected static final String DEFAULT_IS_ANGULAR_REDIRECT_VIEW = "false";
    protected static final String SHIRO_SESSION_PREFIX_PROPERTY = "context.sso.shiro.session.prefix";
    protected static final String SHIRO_CLIENT_EXPIRE_TIME_PROPERTY = "context.sso.shiro.client.expire.time";
    protected static final String SHIRO_SESSION_LISTENER_EXPIRE_TIME_PROPERTY = "context.sso.shiro.session.listener.expire.time";
    protected static final String IS_BIND_SESSION_FORWARD_PROPERTY = "context.sso.is.bind.session.forward";
    protected static final String BIND_SESSION_FORWARD_URL_PROPERTY = "context.sso.bind.session.forward.url";
    protected static final String BIND_SESSION_REDIRECT_URL_PROPERTY = "context.sso.bind.session.redirect.url";
    protected static final String IS_ANGULAR_REDIRECT_VIEW_PROPERTY = "context.sso.is.angular.redirect.view";
    protected static final String SHIRO_SESSION_PREFIX = System.getProperty("context.sso.shiro.session.prefix", "SHIRO_SESSION_");
    protected static final int SHIRO_CLIENT_EXPIRE_TIME = Integer.parseInt(System.getProperty("context.sso.shiro.client.expire.time", "3600"));
    protected static final int SHIRO_SESSION_LISTENER_EXPIRE_TIME = Integer.parseInt(System.getProperty("context.sso.shiro.session.listener.expire.time", "7200"));
    protected static final boolean IS_BIND_SESSION_FORWARD = Boolean.parseBoolean(System.getProperty("context.sso.is.bind.session.forward", "true"));
    protected static final String BIND_SESSION_FORWARD_URL = System.getProperty("context.sso.bind.session.forward.url", "/pages/login.jsp");
    protected static final String BIND_SESSION_REDIRECT_URL = System.getProperty("context.sso.bind.session.redirect.url", "");
    protected static final boolean IS_ANGULAR_REDIRECT_VIEW = Boolean.parseBoolean(System.getProperty("context.sso.is.angular.redirect.view", "false"));
    protected static final String AUTHENTICATED_SESSION_KEY = "AUTHENTICATED_SESSION_KEY";
    protected static final String PRINCIPALS_SESSION_KEY = "PRINCIPALS_SESSION_KEY";
    @Inject
    protected SSOService ssoService;

    @Override
    public String getSession(String clientSessionId) {
        String sessionSerail;
        String serverSessionId = SHIRO.get(SHIRO_CLIENT_SESSION_PREFIX + clientSessionId);
        if (StringUtils.isNotBlank((CharSequence)serverSessionId) && StringUtils.isNotBlank((CharSequence)(sessionSerail = SHIRO.get(SHIRO_SESSION_PREFIX + serverSessionId)))) {
            try {
                if (!this.validationSession(sessionSerail)) {
                    return DEFAULT_BIND_SESSION_REDIRECT_URL;
                }
                this.expireSession(clientSessionId, serverSessionId);
                return sessionSerail;
            }
            catch (Throwable e) {
                LOGGER.error("Session validation error: {}", new Object[]{e.getMessage()});
                return DEFAULT_BIND_SESSION_REDIRECT_URL;
            }
        }
        return DEFAULT_BIND_SESSION_REDIRECT_URL;
    }

    protected boolean validationSession(String sessionSerail) {
        Session session = (Session)SerializableUtils.decode((String)sessionSerail);
        if (session instanceof ValidatingSession && !((ValidatingSession)session).isValid()) {
            return false;
        }
        for (Object attributeKey : session.getAttributeKeys()) {
            if (this.validationSession0(session, attributeKey)) continue;
            return false;
        }
        this.accessSession(session);
        return true;
    }

    protected boolean validationSession0(Session session, Object attributeKey) {
        if (((String)attributeKey).contains(AUTHENTICATED_SESSION_KEY) && !this.validationAuthenticatedSession(session.getAttribute(attributeKey))) {
            return false;
        }
        return !((String)attributeKey).contains(PRINCIPALS_SESSION_KEY) || this.validationPrincipalsSession(session.getAttribute(attributeKey));
    }

    protected boolean validationAuthenticatedSession(Object value) {
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    protected boolean validationPrincipalsSession(Object value) {
        return value != null && value instanceof SimplePrincipalCollection && !((SimplePrincipalCollection)value).isEmpty();
    }

    protected void accessSession(Session session) {
        ((SimpleSession)session).setLastAccessTime(new Date());
        this.ssoService.update(session);
    }

    @Override
    public String registrySession(String clientSessionId, String serverEncryptSessionId) {
        String serverSessionId = CryptUtil.decrypt((String)serverEncryptSessionId);
        String sessionSerail = SHIRO.get(SHIRO_SESSION_PREFIX + serverSessionId);
        if (StringUtils.isNotBlank((CharSequence)sessionSerail)) {
            if (!this.validationSession(sessionSerail)) {
                return DEFAULT_BIND_SESSION_REDIRECT_URL;
            }
            this.storageSession(clientSessionId, serverSessionId);
            return sessionSerail;
        }
        return DEFAULT_BIND_SESSION_REDIRECT_URL;
    }

    @Override
    public ResultMap removeSession(String clientSessionId) {
        try {
            String sessionSerail;
            String serverSessionId = SHIRO.get(SHIRO_CLIENT_SESSION_PREFIX + clientSessionId);
            if (StringUtils.isNotBlank((CharSequence)serverSessionId) && StringUtils.isNotBlank((CharSequence)(sessionSerail = SHIRO.get(SHIRO_SESSION_PREFIX + serverSessionId)))) {
                Session session = (Session)SerializableUtils.decode((String)sessionSerail);
                this.ssoService.delete(session);
                this.clearOldSession(clientSessionId);
                return HttpStatus.OK.to();
            }
        }
        catch (Throwable e) {
            LOGGER.error("Remove Session error: {}", new Object[]{e.getMessage()});
            return ResultMap.create((String)e.getMessage(), (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return HttpStatus.BAD_REQUEST.to();
    }

    @Override
    public View bindSession(String service, String clientSessionId) {
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated() || subject.isRemembered()) {
            String serverSessionId = (String)((Object)subject.getSession().getId());
            this.storageSession(clientSessionId, serverSessionId);
            return new RedirectView(service);
        }
        return this.unAuthenticated(service);
    }

    protected void storageSession(String clientSessionId, String serverSessionId) {
        this.clearOldSession(clientSessionId);
        SHIRO.set(SHIRO_CLIENT_SESSION_PREFIX + clientSessionId, serverSessionId);
        SHIRO.sadd(SHIRO_SESSION_LISTENER_PREFIX + serverSessionId, new String[]{clientSessionId});
        this.expireSession(clientSessionId, serverSessionId);
    }

    protected void expireSession(String clientSessionId, String serverSessionId) {
        SHIRO.expire(SHIRO_CLIENT_SESSION_PREFIX + clientSessionId, SHIRO_CLIENT_EXPIRE_TIME);
        SHIRO.expire(SHIRO_SESSION_LISTENER_PREFIX + serverSessionId, SHIRO_SESSION_LISTENER_EXPIRE_TIME);
    }

    protected void clearOldSession(String clientSessionId) {
        String serverSessionId = SHIRO.get(SHIRO_CLIENT_SESSION_PREFIX + clientSessionId);
        if (StringUtils.isNotBlank((CharSequence)serverSessionId)) {
            SHIRO.srem(SHIRO_SESSION_LISTENER_PREFIX + serverSessionId, new String[]{clientSessionId});
            SHIRO.del(new String[]{SHIRO_CLIENT_SESSION_PREFIX + clientSessionId});
        }
    }

    protected void addServiceAttribute(String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            Model model = (Model)HttpRequestFilter.HttpContext.get(Model.class);
            model.addAttribute(Protocol.SHIRO.getServiceParameterName(), (Object)service);
        }
    }

    protected View unAuthenticated(String service) {
        this.addServiceAttribute(service);
        return this.unAuthenticated();
    }

    protected View unAuthenticated() {
        if (IS_BIND_SESSION_FORWARD) {
            return new ForwardView(BIND_SESSION_FORWARD_URL, true);
        }
        if (IS_ANGULAR_REDIRECT_VIEW) {
            return new AngularRedirectView(BIND_SESSION_REDIRECT_URL);
        }
        return new RedirectView(BIND_SESSION_REDIRECT_URL);
    }
}

