/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.web.component.impl;

import com.google.common.base.Charsets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.nanoframework.commons.util.SerializableUtils;
import org.nanoframework.commons.util.StringUtils;
import org.nanoframework.extension.shiro.util.ShiroSecurityHelper;
import org.nanoframework.extension.shiro.web.component.Status;
import org.nanoframework.extension.shiro.web.component.impl.AbstractSSOComponent;
import org.nanoframework.web.server.filter.HttpRequestFilter;
import org.nanoframework.web.server.http.status.HttpStatus;
import org.nanoframework.web.server.http.status.ResultMap;
import org.nanoframework.web.server.mvc.Model;
import org.nanoframework.web.server.mvc.View;

@Singleton
public class SSOComponentImpl
extends AbstractSSOComponent {
    protected static final String ERROR_MODEL_NAME = "error";
    @Inject
    protected ShiroSecurityHelper helper;

    @Override
    public String getSession(String clientSessionId) {
        for (int count = 0; count < ERROR_RETRY; ++count) {
            try {
                return super.getSession(clientSessionId);
            }
            catch (Throwable e) {
                LOGGER.error("getSession Error: {}, retry {}...", new Object[]{e.getMessage(), count + 1});
                continue;
            }
        }
        return "";
    }

    @Override
    public String registrySession(String clientSessionId, String serverEncryptSessionId) {
        for (int count = 0; count < ERROR_RETRY; ++count) {
            try {
                return super.registrySession(clientSessionId, serverEncryptSessionId);
            }
            catch (Throwable e) {
                LOGGER.error("getSession Error: {}, retry {}...", new Object[]{e.getMessage(), count + 1});
                continue;
            }
        }
        return "";
    }

    @Override
    public View bindSession(String service, String clientSessionId) {
        for (int count = 0; count < ERROR_RETRY; ++count) {
            try {
                return super.bindSession(service, clientSessionId);
            }
            catch (Throwable e) {
                LOGGER.error("getSession Error: {}, retry {}...", new Object[]{e.getMessage(), count + 1});
                continue;
            }
        }
        return this.unAuthenticated(service);
    }

    @Override
    public ResultMap syncSessionAttribute(String clientSessionId, String serialAttribute) {
        try {
            String sessionSerail = super.getSession(clientSessionId);
            Session session = (Session)SerializableUtils.decode((String)sessionSerail);
            Map map = (Map)SerializableUtils.decode((String)serialAttribute);
            map.forEach((key, value) -> session.setAttribute(key, value));
            this.accessSession(session);
            return HttpStatus.OK.to();
        }
        catch (Throwable e) {
            LOGGER.error("Sync session error: {}", new Object[]{e.getMessage()});
            return ResultMap.create((String)e.getMessage(), (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResultMap syncSessionMaxInactiveInternal(String clientSessionId, Integer maxInactiveInternal) {
        try {
            String sessionSerail = super.getSession(clientSessionId);
            Session session = (Session)SerializableUtils.decode((String)sessionSerail);
            session.setTimeout((long)(maxInactiveInternal * 1000));
            this.accessSession(session);
            return HttpStatus.OK.to();
        }
        catch (Throwable e) {
            LOGGER.error("Sync session error: {}", new Object[]{e.getMessage()});
            return ResultMap.create((String)e.getMessage(), (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public View loginFailure(String shiroLoginFailure, String service) {
        Model model = (Model)HttpRequestFilter.HttpContext.get(Model.class);
        if (AccountException.class.getName().equals(shiroLoginFailure)) {
            model.addAttribute(ERROR_MODEL_NAME, (Object)"\u65e0\u6548\u7684\u7528\u6237\u540d");
        } else if (UnknownAccountException.class.getName().equals(shiroLoginFailure)) {
            model.addAttribute(ERROR_MODEL_NAME, (Object)"\u7528\u6237\u4e0d\u5b58\u5728");
        } else if (IncorrectCredentialsException.class.getName().equals(shiroLoginFailure)) {
            model.addAttribute(ERROR_MODEL_NAME, (Object)"\u5bc6\u7801\u9519\u8bef");
        } else if (shiroLoginFailure != null) {
            model.addAttribute(ERROR_MODEL_NAME, (Object)("\u672a\u77e5\u9519\u8bef\uff1a" + shiroLoginFailure));
        } else {
            model.addAttribute(ERROR_MODEL_NAME, (Object)"\u672a\u77e5\u9519\u8bef");
        }
        return this.unAuthenticated(service);
    }

    @Override
    public Map<String, Object> login(UsernamePasswordToken token, String service) {
        if (StringUtils.isBlank((CharSequence)token.getUsername()) || ArrayUtils.isEmpty((char[])token.getPassword())) {
            return Status.INVALID_USER_PASS.beanToMap();
        }
        Subject subject = SecurityUtils.getSubject();
        try {
            if (subject.isAuthenticated()) {
                return this.createOKResult(service);
            }
            subject.login((AuthenticationToken)token);
            if (subject.isAuthenticated()) {
                return this.createOKResult(service);
            }
            return Status.INVALID_AUTH.beanToMap();
        }
        catch (AuthenticationException e) {
            return this.authenticationException(e);
        }
        catch (Throwable e) {
            LOGGER.error("\u5904\u7406\u5f02\u5e38: {}", new Object[]{e.getMessage()});
            return Status.INTERNAL_SERVER_ERROR.beanToMap();
        }
    }

    protected Map<String, Object> authenticationException(AuthenticationException e) {
        LOGGER.error("\u6743\u9650\u8ba4\u8bc1\u5931\u8d25: {}", new Object[]{e.getMessage()});
        if (e.getMessage().indexOf("did not match the expected credentials") > -1) {
            return Status.PASSWORD_ERROR.beanToMap();
        }
        Map authError = Status.UNAUTH.beanToMap();
        authError.put("message", e.getMessage());
        return authError;
    }

    @Override
    public ResultMap logout() {
        try {
            Subject subject = SecurityUtils.getSubject();
            if (subject.isAuthenticated() || subject.isRemembered()) {
                subject.logout();
                return Status.OK;
            }
            return Status.UNLOGIN;
        }
        catch (Throwable e) {
            LOGGER.error("\u5904\u7406\u5f02\u5e38: {}", new Object[]{e.getMessage()});
            return Status.INTERNAL_SERVER_ERROR;
        }
    }

    @Override
    public Map<String, Object> isLogined(String service) {
        try {
            Subject subject = SecurityUtils.getSubject();
            if (subject.isAuthenticated() || subject.isRemembered()) {
                return this.createOKResult(service);
            }
            return Status.UNLOGIN.beanToMap();
        }
        catch (Throwable e) {
            LOGGER.error("\u767b\u9646\u6821\u9a8c\u5f02\u5e38: {}", new Object[]{e.getMessage()});
            return Status.INTERNAL_SERVER_ERROR.beanToMap();
        }
    }

    protected Map<String, Object> createOKResult() {
        Map ok = Status.OK.beanToMap();
        String username = this.helper.getCurrentUsername();
        ok.put("username", username);
        return ok;
    }

    protected Map<String, Object> createOKResult(String service) {
        Map<String, Object> ok = this.createOKResult();
        if (StringUtils.isNotBlank((CharSequence)service)) {
            try {
                ok.put("service", URLDecoder.decode(service, Charsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("service url decode error: {}", new Object[]{e.getMessage()});
            }
        }
        return ok;
    }
}

