/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.web.filter.authc;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.nanoframework.commons.crypt.CryptUtil;
import org.nanoframework.commons.support.logging.Logger;
import org.nanoframework.commons.support.logging.LoggerFactory;
import org.nanoframework.commons.util.StringUtils;
import org.nanoframework.extension.shiro.Protocol;

public class SSOAuthenticationFilter
extends FormAuthenticationFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOAuthenticationFilter.class);

    protected void issueSuccessRedirect(ServletRequest request, ServletResponse response) throws Exception {
        if (this.bindService(request, response)) {
            return;
        }
        super.issueSuccessRedirect(request, response);
    }

    protected boolean bindService(ServletRequest request, ServletResponse response) throws IOException {
        String service = request.getParameter(Protocol.SHIRO.getServiceParameterName());
        if (StringUtils.isNotBlank((CharSequence)service)) {
            Session session = SecurityUtils.getSubject().getSession();
            String sessionId = CryptUtil.encrypt((String)((String)((Object)session.getId())));
            String redirectService = !service.contains("?") ? service + '?' + Protocol.SHIRO.getArtifactParameterName() + '=' + sessionId : service + '&' + Protocol.SHIRO.getArtifactParameterName() + '=' + sessionId;
            LOGGER.debug("Redirect: {}", new Object[]{redirectService});
            ((HttpServletResponse)response).sendRedirect(redirectService);
            return true;
        }
        return false;
    }
}

