/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.web.service.impl;

import com.google.inject.Singleton;
import java.util.Collection;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.nanoframework.extension.shiro.realm.JdbcRealm;
import org.nanoframework.extension.shiro.web.exception.MultiRealmException;
import org.nanoframework.extension.shiro.web.service.RealmService;

@Singleton
public class RealmServiceImpl
implements RealmService {
    @Override
    public AuthorizationInfo getAuthorizationInfo() {
        return this.getAuthorizationInfo(SecurityUtils.getSubject().getPrincipals());
    }

    @Override
    public AuthorizationInfo getAuthorizationInfo(PrincipalCollection principals) {
        Realm realm = this.getRealm();
        if (realm instanceof JdbcRealm) {
            return ((JdbcRealm)realm).getAuthorizationInfo(principals);
        }
        throw new IllegalArgumentException("Realm is not instanceof " + JdbcRealm.class.getName());
    }

    protected Realm getRealm() {
        Collection realms;
        SecurityManager securityManager = SecurityUtils.getSecurityManager();
        if (securityManager instanceof RealmSecurityManager && !CollectionUtils.isEmpty((Collection)(realms = ((RealmSecurityManager)securityManager).getRealms())) && realms.size() == 1) {
            return (Realm)realms.iterator().next();
        }
        throw new MultiRealmException();
    }
}

