/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.web.service.impl;

import com.google.inject.Singleton;
import java.io.Serializable;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionsSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.nanoframework.extension.shiro.web.service.SSOService;

@Singleton
public class SSOServiceImpl
implements SSOService {
    @Override
    public Session readSession(Serializable sessionId) throws UnknownSessionException {
        SessionDAO sessionDAO = this.getSessionDAO();
        if (sessionDAO != null) {
            sessionDAO.readSession(sessionId);
        }
        return null;
    }

    @Override
    public void update(Session session) throws UnknownSessionException {
        SessionDAO sessionDAO = this.getSessionDAO();
        if (sessionDAO != null) {
            sessionDAO.update(session);
        }
    }

    @Override
    public void delete(Session session) {
        SessionDAO sessionDAO = this.getSessionDAO();
        if (sessionDAO != null) {
            sessionDAO.delete(session);
        }
    }

    protected SessionDAO getSessionDAO() {
        SessionManager sessionManager;
        SecurityManager securityManager = SecurityUtils.getSecurityManager();
        if (securityManager instanceof SessionsSecurityManager && (sessionManager = ((SessionsSecurityManager)securityManager).getSessionManager()) instanceof DefaultSessionManager) {
            return ((DefaultSessionManager)sessionManager).getSessionDAO();
        }
        return null;
    }
}

