/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.web.session.mgt;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.util.WebUtils;
import org.nanoframework.commons.support.logging.Logger;
import org.nanoframework.commons.support.logging.LoggerFactory;

public class CookieRememberMeManager
extends org.apache.shiro.web.mgt.CookieRememberMeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CookieRememberMeManager.class);

    protected void rememberSerializedIdentity(Subject subject, byte[] serialized) {
        if (!WebUtils.isHttp((Object)subject)) {
            if (LOGGER.isDebugEnabled()) {
                String msg = "Subject argument is not an HTTP-aware instance.  This is required to obtain a servlet request and response in order to set the rememberMe cookie. Returning immediately and ignoring rememberMe operation.";
                LOGGER.debug(msg);
            }
            return;
        }
        HttpServletRequest request = WebUtils.getHttpRequest((Object)subject);
        HttpServletResponse response = WebUtils.getHttpResponse((Object)subject);
        String base64 = Base64.encodeToString((byte[])serialized);
        Cookie cookie = this.getCookie();
        cookie.setValue(base64);
        cookie.saveTo(request, response);
    }
}

