/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.extension.shiro.web.session.mgt;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.util.WebUtils;
import org.nanoframework.commons.support.logging.Logger;
import org.nanoframework.commons.support.logging.LoggerFactory;

public class DefaultWebSessionManager
extends org.apache.shiro.web.session.mgt.DefaultWebSessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWebSessionManager.class);

    protected void onStart(Session session, SessionContext context) {
        if (!WebUtils.isHttp((Object)context)) {
            LOGGER.debug("SessionContext argument is not HTTP compatible or does not have an HTTP request/response pair. No session ID cookie will be set.");
            return;
        }
        HttpServletRequest request = WebUtils.getHttpRequest((Object)context);
        HttpServletResponse response = WebUtils.getHttpResponse((Object)context);
        if (this.isSessionIdCookieEnabled()) {
            Serializable sessionId = session.getId();
            this.storeSessionId(sessionId, request, response);
        } else {
            LOGGER.debug("Session ID cookie is disabled.  No cookie has been set for new session with id {}", new Object[]{session.getId()});
        }
        request.removeAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_SOURCE);
        request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_IS_NEW, (Object)Boolean.TRUE);
    }

    private void storeSessionId(Serializable currentId, HttpServletRequest request, HttpServletResponse response) {
        if (currentId == null) {
            String msg = "sessionId cannot be null when persisting for subsequent requests.";
            throw new IllegalArgumentException(msg);
        }
        String idString = currentId.toString();
        Cookie cookie = this.getSessionIdCookie();
        cookie.setValue(idString);
        cookie.saveTo(request, response);
        LOGGER.debug("Set session ID cookie for session with id {}", new Object[]{idString});
    }
}

