/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.orm.mybatis;

import java.util.Properties;
import org.mybatis.guice.datasource.helper.JdbcHelper;
import org.nanoframework.commons.entity.BaseEntity;
import org.nanoframework.commons.util.Assert;
import org.nanoframework.orm.PoolType;

public class DataSourceConfig
extends BaseEntity {
    private static final long serialVersionUID = -3733512377087727530L;
    public static final String DEFAULT_MYBATIS_CONFIG_PATH = "/mybatis-config-";
    public static final String XML_SUFFIX = ".xml";
    private String[] mapperPackageName;
    private Properties jdbc;
    private JdbcHelper helper;
    private String envId;
    private String mybatisConfigPath;
    private PoolType poolType;
    private String[] typeAliasPackageName;

    public DataSourceConfig(String[] mapperPackageName, String[] typeAliasPackageName, Properties jdbc, PoolType poolType) {
        Assert.notNull((Object)jdbc);
        this.envId = jdbc.getProperty("mybatis.environment.id");
        Assert.hasLength((String)this.envId);
        Assert.notNull((Object)poolType);
        this.mapperPackageName = mapperPackageName;
        this.jdbc = jdbc;
        this.poolType = poolType;
        this.mybatisConfigPath = DEFAULT_MYBATIS_CONFIG_PATH + poolType.name().toLowerCase() + XML_SUFFIX;
        this.typeAliasPackageName = typeAliasPackageName;
    }

    public String[] getMapperPackageName() {
        return this.mapperPackageName;
    }

    public void setMapperPackageName(String[] mapperPackageName) {
        this.mapperPackageName = mapperPackageName;
    }

    public Properties getJdbc() {
        return this.jdbc;
    }

    public void setJdbc(Properties jdbc) {
        this.jdbc = jdbc;
    }

    public JdbcHelper getHelper() {
        return this.helper;
    }

    public void setHelper(JdbcHelper helper) {
        this.helper = helper;
    }

    public String getEnvId() {
        return this.envId;
    }

    public void setEnvId(String envId) {
        this.envId = envId;
    }

    public String getMybatisConfigPath() {
        return this.mybatisConfigPath;
    }

    public void setMybatisConfigPath(String mybatisConfigPath) {
        this.mybatisConfigPath = mybatisConfigPath;
    }

    public PoolType getPoolType() {
        return this.poolType;
    }

    public void setPoolType(PoolType poolType) {
        this.poolType = poolType;
    }

    public String[] getTypeAliasPackageName() {
        return this.typeAliasPackageName;
    }

    public void setTypeAliasPackageName(String[] typeAliasPackageName) {
        this.typeAliasPackageName = typeAliasPackageName;
    }
}

