/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.orm.mybatis;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.ibatis.session.SqlSessionManager;

public class GlobalSqlSession {
    private static ConcurrentMap<String, SqlSessionManager> globals = Maps.newConcurrentMap();

    private GlobalSqlSession() {
    }

    public static void set(String type, SqlSessionManager global) {
        globals.put(type, global);
    }

    public static final SqlSessionManager get(String type) {
        return (SqlSessionManager)globals.get(type);
    }

    public static final SqlSessionManager[] get(String ... types) {
        if (types.length > 0) {
            ArrayList managers = Lists.newArrayList();
            for (String type : types) {
                SqlSessionManager manager = (SqlSessionManager)globals.get(type);
                if (manager == null) {
                    throw new IllegalArgumentException("\u65e0\u6548\u7684\u6570\u636e\u6e90\u540d\u79f0: " + type);
                }
                managers.add(manager);
            }
            return managers.toArray(new SqlSessionManager[managers.size()]);
        }
        return null;
    }

    public static final Set<String> keys() {
        return globals.keySet();
    }
}

