/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.orm.mybatis;

import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.util.Providers;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.inject.Provider;
import javax.servlet.ServletConfig;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.ibatis.type.TypeAliasRegistry;
import org.nanoframework.commons.format.ClassCast;
import org.nanoframework.commons.io.ClassPathResource;
import org.nanoframework.commons.loader.LoaderException;
import org.nanoframework.commons.util.Assert;
import org.nanoframework.commons.util.CollectionUtils;
import org.nanoframework.commons.util.ResourceUtils;
import org.nanoframework.core.plugins.Module;
import org.nanoframework.orm.mybatis.DataSourceConfig;
import org.nanoframework.orm.mybatis.GlobalSqlSession;
import org.nanoframework.orm.mybatis.MapperProvider;

public class MultiDataSourceModule
extends AbstractModule
implements Module {
    private String envId;
    private Properties jdbc;
    private String mybatisConfigPath;
    private String[] mapperPackageName;
    private String[] typeAliasPackageName;

    public MultiDataSourceModule(DataSourceConfig conf) {
        this.jdbc = conf.getJdbc();
        this.envId = conf.getEnvId();
        this.mybatisConfigPath = conf.getMybatisConfigPath();
        this.mapperPackageName = conf.getMapperPackageName();
        this.typeAliasPackageName = conf.getTypeAliasPackageName();
        Assert.notNull((Object)this.jdbc);
        Assert.hasLength((String)this.envId);
        Assert.hasLength((String)this.mybatisConfigPath);
        Assert.notEmpty((Object[])this.mapperPackageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configure() {
        Reader reader = null;
        try {
            InputStream input;
            try {
                ClassPathResource resource = new ClassPathResource(this.mybatisConfigPath);
                input = resource.getInputStream();
                if (input == null) {
                    input = new FileInputStream(ResourceUtils.getFile((String)this.mybatisConfigPath));
                }
            }
            catch (IOException e) {
                throw new LoaderException("\u52a0\u8f7d\u6587\u4ef6\u5f02\u5e38: " + e.getMessage());
            }
            reader = new InputStreamReader(input);
            SqlSessionFactory sessionFactory = new SqlSessionFactoryBuilder().build(reader, this.envId, this.jdbc);
            SqlSessionManager sessionManager = SqlSessionManager.newInstance((SqlSessionFactory)sessionFactory);
            GlobalSqlSession.set(this.envId, sessionManager);
            Configuration configuration = sessionFactory.getConfiguration();
            MapperRegistry registry = configuration.getMapperRegistry();
            for (String pkg : this.mapperPackageName) {
                Set<Class<?>> classes = this.getClasses(pkg);
                if (CollectionUtils.isEmpty(classes)) continue;
                for (Class<?> cls : classes) {
                    if (registry.hasMapper(cls)) continue;
                    registry.addMapper(cls);
                }
            }
            TypeAliasRegistry typeAliasRegistry = configuration.getTypeAliasRegistry();
            for (String pkg : this.typeAliasPackageName) {
                typeAliasRegistry.registerAliases(pkg);
            }
            this.settings(this.jdbc, configuration);
            Collection mapperClasses = registry.getMappers();
            for (Class mapperType : mapperClasses) {
                this.bindMapper(mapperType, sessionManager);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void settings(Properties proerties, Configuration conf) {
        String prefix = "mybatis.settings.";
        List<Field> fields = this.allFields(Lists.newArrayList(), Configuration.class);
        proerties.keySet().stream().filter(key -> ((String)key).startsWith("mybatis.settings.")).forEach(k -> {
            String key = (String)k;
            String value = proerties.getProperty(key);
            String name = key.substring("mybatis.settings.".length());
            fields.stream().filter(field -> StringUtils.equals((CharSequence)field.getName(), (CharSequence)name)).forEach(field -> {
                try {
                    Object val = ClassCast.cast((String)value, (String)field.getType().getName());
                    field.setAccessible(true);
                    field.set(conf, val);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        });
    }

    protected final void bindDataSourceProviderType(Class<? extends Provider<DataSource>> dataSourceProviderType) {
        Assert.notNull(dataSourceProviderType, (String)"Parameter 'dataSourceProviderType' must be not null");
        this.bind(DataSource.class).toProvider(dataSourceProviderType).in(Scopes.SINGLETON);
    }

    final <T> void bindMapper(Class<T> mapperType, SqlSessionManager sessionManager) {
        this.bind(mapperType).toProvider(Providers.guicify(new MapperProvider<T>(mapperType, sessionManager))).in(Scopes.SINGLETON);
    }

    final Set<Class<?>> getClasses(String packageName) {
        return this.getClasses((ResolverUtil.Test)new ResolverUtil.IsA(Object.class), packageName);
    }

    final Set<Class<?>> getClasses(ResolverUtil.Test test, String packageName) {
        Assert.notNull((Object)test, (String)"Parameter 'test' must not be null");
        Assert.notNull((Object)packageName, (String)"Parameter 'packageName' must not be null");
        return new ResolverUtil().find(test, packageName).getClasses();
    }

    private List<Field> allFields(List<Field> allFields, Class<?> cls) {
        allFields.addAll(Arrays.asList(cls.getDeclaredFields()));
        if (cls.getSuperclass() == null) {
            return allFields;
        }
        return this.allFields(allFields, cls.getSuperclass());
    }

    public List<Module> load() throws Throwable {
        return Lists.newArrayList((Object[])new Module[]{this});
    }

    public void config(ServletConfig config) throws Throwable {
    }
}

