/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.orm.mybatis;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSessionManager;
import org.nanoframework.orm.mybatis.GlobalSqlSession;
import org.nanoframework.orm.mybatis.MultiTransactional;

public final class MultiTransactionalMethodInterceptor
implements MethodInterceptor {
    private static final Class<?>[] CAUSE_TYPES = new Class[]{Throwable.class};
    private static final Class<?>[] MESSAGE_CAUSE_TYPES = new Class[]{String.class, Throwable.class};
    private final Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        SqlSessionManager[] sqlSessionManager;
        Method interceptedMethod = invocation.getMethod();
        MultiTransactional transactional = interceptedMethod.getAnnotation(MultiTransactional.class);
        if (transactional == null) {
            transactional = interceptedMethod.getDeclaringClass().getAnnotation(MultiTransactional.class);
        }
        if ((sqlSessionManager = GlobalSqlSession.get(transactional.envId())) == null || sqlSessionManager.length == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u6e90\u540d\u79f0\uff0c\u4e0d\u5f00\u542f\u4e8b\u52a1\uff0c\u76f4\u63a5\u6267\u884c\u6570\u636e\u5e93\u64cd\u4f5c", new Object[0]));
            }
            return invocation.proceed();
        }
        boolean isSessionInherited = this.isManagedSessionStarted(sqlSessionManager);
        if (!isSessionInherited) {
            this.startManagedSession(transactional, sqlSessionManager);
        }
        Object object = null;
        boolean needsRollback = transactional.rollbackOnly();
        try {
            object = invocation.proceed();
        }
        catch (Throwable t) {
            needsRollback = true;
            throw this.convertThrowableIfNeeded(invocation, transactional, t);
        }
        finally {
            if (!isSessionInherited) {
                try {
                    if (needsRollback) {
                        this.rollback(true, sqlSessionManager);
                    } else {
                        this.commit(transactional.force(), sqlSessionManager);
                    }
                }
                finally {
                    this.close(sqlSessionManager);
                }
            }
        }
        return object;
    }

    private boolean isManagedSessionStarted(SqlSessionManager[] sqlSessionManager) {
        for (SqlSessionManager manager : sqlSessionManager) {
            if (manager.isManagedSessionStarted()) continue;
            return false;
        }
        return true;
    }

    private void startManagedSession(MultiTransactional transactional, SqlSessionManager[] sqlSessionManager) {
        for (SqlSessionManager manager : sqlSessionManager) {
            if (manager.isManagedSessionStarted()) continue;
            manager.startManagedSession(transactional.executorType(), transactional.isolation().getTransactionIsolationLevel());
        }
    }

    private void rollback(boolean force, SqlSessionManager[] sqlSessionManager) {
        for (SqlSessionManager manager : sqlSessionManager) {
            try {
                manager.rollback(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void commit(boolean force, SqlSessionManager[] sqlSessionManager) {
        for (SqlSessionManager manager : sqlSessionManager) {
            manager.commit(true);
        }
    }

    private void close(SqlSessionManager[] sqlSessionManager) {
        for (SqlSessionManager manager : sqlSessionManager) {
            try {
                manager.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Throwable convertThrowableIfNeeded(MethodInvocation invocation, MultiTransactional transactional, Throwable t) {
        Object[] initargsType;
        Object[] initargs;
        String errorMessage;
        Method interceptedMethod = invocation.getMethod();
        for (Class<?> exceptionClass : interceptedMethod.getExceptionTypes()) {
            if (!exceptionClass.isAssignableFrom(t.getClass())) continue;
            return t;
        }
        if (transactional.rethrowExceptionsAs().isAssignableFrom(t.getClass())) {
            return t;
        }
        if (transactional.exceptionMessage().length() != 0) {
            errorMessage = String.format(transactional.exceptionMessage(), invocation.getArguments());
            initargs = new Object[]{errorMessage, t};
            initargsType = MESSAGE_CAUSE_TYPES;
        } else {
            initargs = new Object[]{t};
            initargsType = CAUSE_TYPES;
        }
        Constructor<? extends Throwable> exceptionConstructor = MultiTransactionalMethodInterceptor.getMatchingConstructor(transactional.rethrowExceptionsAs(), initargsType);
        Throwable rethrowEx = null;
        if (exceptionConstructor != null) {
            try {
                rethrowEx = exceptionConstructor.newInstance(initargs);
            }
            catch (Exception e) {
                errorMessage = String.format("Impossible to re-throw '%s', it needs the constructor with %s argument(s).", transactional.rethrowExceptionsAs().getName(), Arrays.toString(initargsType));
                this.log.error(errorMessage, (Throwable)e);
                rethrowEx = new RuntimeException(errorMessage, e);
            }
        } else {
            errorMessage = String.format("Impossible to re-throw '%s', it needs the constructor with %s or %s argument(s).", transactional.rethrowExceptionsAs().getName(), Arrays.toString(CAUSE_TYPES), Arrays.toString(MESSAGE_CAUSE_TYPES));
            this.log.error(errorMessage);
            rethrowEx = new RuntimeException(errorMessage);
        }
        return rethrowEx;
    }

    private static <E extends Throwable> Constructor<E> getMatchingConstructor(Class<E> type, Class<?>[] argumentsType) {
        for (Class<E> currentType = type; Object.class != currentType; currentType = currentType.getSuperclass()) {
            for (Constructor<?> constructor : currentType.getConstructors()) {
                if (!Arrays.equals(argumentsType, constructor.getParameterTypes())) continue;
                return constructor;
            }
        }
        return null;
    }
}

