/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.orm.mybatis;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.nanoframework.commons.support.logging.Logger;
import org.nanoframework.commons.support.logging.LoggerFactory;
import org.nanoframework.commons.util.Assert;
import org.nanoframework.orm.DataSourceLoader;
import org.nanoframework.orm.ORMType;
import org.nanoframework.orm.mybatis.DataSourceConfig;
import org.nanoframework.orm.mybatis.MultiDataSourceModule;
import org.nanoframework.orm.mybatis.MultiTransactionalModule;

public class MybatisDataSourceLoader
extends DataSourceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MybatisDataSourceLoader.class);
    private final long time;
    private final List<DataSourceConfig> dsc = Lists.newArrayList();

    public MybatisDataSourceLoader() {
        this.time = System.currentTimeMillis();
        this.load();
        this.toModule();
    }

    public void load() {
        this.load0(ORMType.MYBATIS);
    }

    public void toConfig(Properties properties) {
        Assert.notNull((Object)properties, (String)"\u6570\u636e\u6e90\u5c5e\u6027\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        Object[] mapperPackageName = properties.getProperty("mapper.package.name", "NULL").split(",");
        String[] typeAliasPackageName = properties.getProperty("mapper.package.typeAlias", "").split(",");
        DataSourceConfig config = new DataSourceConfig((String[])mapperPackageName, typeAliasPackageName, properties, this.poolType(properties));
        this.dsc.add(config);
        LOGGER.info("\u521b\u5efa\u6570\u636e\u6e90\u4f9d\u8d56\u6ce8\u5165\u6a21\u5757, Mapper\u5305\u8def\u5f84: [ {} ], \u8017\u65f6: {}ms", new Object[]{StringUtils.join((Object[])mapperPackageName, (String)", "), System.currentTimeMillis() - this.time});
    }

    public void toModule() {
        for (DataSourceConfig config : this.dsc) {
            this.modules.add(new MultiDataSourceModule(config));
        }
        this.modules.add(new MultiTransactionalModule());
    }
}

