/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.orm.mybatis.plugin;

import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.datasource.DataSourceException;
import org.apache.ibatis.datasource.DataSourceFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

public class AbstractDataSourceFactory
implements DataSourceFactory {
    protected DataSource dataSource;

    public void setProperties(Properties properties) {
        Properties driverProperties = new Properties();
        MetaObject metaDataSource = SystemMetaObject.forObject((Object)this.dataSource);
        for (Object key : properties.keySet()) {
            String propertyName = (String)key;
            if (metaDataSource.hasSetter(propertyName)) {
                String value = (String)properties.get(propertyName);
                if (StringUtils.isNotEmpty((CharSequence)value) && value.startsWith("${") && value.endsWith("}")) continue;
                Object convertedValue = this.convertValue(metaDataSource, propertyName, value);
                metaDataSource.setValue(propertyName, convertedValue);
                continue;
            }
            throw new DataSourceException("Unknown DataSource property: " + propertyName);
        }
        if (driverProperties.size() > 0) {
            metaDataSource.setValue("driverProperties", (Object)driverProperties);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private Object convertValue(MetaObject metaDataSource, String propertyName, String value) {
        Object convertedValue = value;
        Class targetType = metaDataSource.getSetterType(propertyName);
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            convertedValue = Integer.valueOf(value);
        } else if (targetType == Long.class || targetType == Long.TYPE) {
            convertedValue = Long.valueOf(value);
        } else if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            convertedValue = Boolean.valueOf(value);
        }
        return convertedValue;
    }
}

