/*
 * Decompiled with CFR 0.152.
 */
package org.nanoframework.orm.mybatis.plugin;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.datasource.DataSourceException;
import org.nanoframework.orm.jdbc.config.TomcatJdbcConfig;
import org.nanoframework.orm.mybatis.plugin.AbstractDataSourceFactory;

public class TomcatJdbcPoolDataSourceFactory
extends AbstractDataSourceFactory {
    private Class<?> tomcatJdbcDataSource;

    public TomcatJdbcPoolDataSourceFactory() {
        try {
            this.tomcatJdbcDataSource = Class.forName("org.apache.tomcat.jdbc.pool.DataSource");
            this.dataSource = (DataSource)this.tomcatJdbcDataSource.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new DataSourceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setProperties(Properties properties) {
        block17: {
            try {
                HashMap map = Maps.newHashMap();
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                    if (StringUtils.isNotEmpty((CharSequence)((String)value)) && ((String)value).startsWith("${") && ((String)value).endsWith("}")) {
                        return;
                    }
                    map.put((String)key, value);
                }));
                TomcatJdbcConfig config = (TomcatJdbcConfig)TomcatJdbcConfig.mapToBean((Map)map, TomcatJdbcConfig.class);
                if (this.tomcatJdbcDataSource != null) {
                    this.tomcatJdbcDataSource.getMethod("setDriverClassName", String.class).invoke((Object)this.dataSource, config.getDriver());
                    this.tomcatJdbcDataSource.getMethod("setUrl", String.class).invoke((Object)this.dataSource, config.getUrl());
                    this.tomcatJdbcDataSource.getMethod("setUsername", String.class).invoke((Object)this.dataSource, config.getUserName());
                    this.tomcatJdbcDataSource.getMethod("setPassword", String.class).invoke((Object)this.dataSource, config.getPasswd());
                    if (config.getInitialSize() != null) {
                        this.tomcatJdbcDataSource.getMethod("setInitialSize", Integer.TYPE).invoke((Object)this.dataSource, config.getInitialSize());
                    }
                    if (config.getMinIdle() != null) {
                        this.tomcatJdbcDataSource.getMethod("setMinIdle", Integer.TYPE).invoke((Object)this.dataSource, config.getMinIdle());
                    }
                    if (config.getMaxWait() != null) {
                        this.tomcatJdbcDataSource.getMethod("setMaxWait", Integer.TYPE).invoke((Object)this.dataSource, config.getMaxWait());
                    }
                    if (config.getMaxActive() != null) {
                        this.tomcatJdbcDataSource.getMethod("setMaxActive", Integer.TYPE).invoke((Object)this.dataSource, config.getMaxActive());
                    }
                    if (config.getTestWhileIdle() != null) {
                        this.tomcatJdbcDataSource.getMethod("setTestWhileIdle", Boolean.TYPE).invoke((Object)this.dataSource, config.getTestWhileIdle());
                    }
                    if (config.getTestOnBorrow() != null) {
                        this.tomcatJdbcDataSource.getMethod("setTestOnBorrow", Boolean.TYPE).invoke((Object)this.dataSource, config.getTestOnBorrow());
                    }
                    if (config.getValidationInterval() != null) {
                        this.tomcatJdbcDataSource.getMethod("setValidationInterval", Long.TYPE).invoke((Object)this.dataSource, config.getValidationInterval());
                    }
                    if (config.getTimeBetweenEvictionRunsMillis() != null) {
                        this.tomcatJdbcDataSource.getMethod("setTimeBetweenEvictionRunsMillis", Integer.TYPE).invoke((Object)this.dataSource, config.getTimeBetweenEvictionRunsMillis());
                    }
                    if (config.getLogAbandoned() != null) {
                        this.tomcatJdbcDataSource.getMethod("setLogAbandoned", Boolean.TYPE).invoke((Object)this.dataSource, config.getLogAbandoned());
                    }
                    if (config.getRemoveAbandoned() != null) {
                        this.tomcatJdbcDataSource.getMethod("setRemoveAbandoned", Boolean.TYPE).invoke((Object)this.dataSource, config.getRemoveAbandoned());
                    }
                    if (config.getRemoveAbandonedTimeout() != null) {
                        this.tomcatJdbcDataSource.getMethod("setRemoveAbandonedTimeout", Integer.TYPE).invoke((Object)this.dataSource, config.getRemoveAbandonedTimeout());
                    }
                    if (config.getMinEvictableIdleTimeMillis() != null) {
                        this.tomcatJdbcDataSource.getMethod("setMinEvictableIdleTimeMillis", Integer.TYPE).invoke((Object)this.dataSource, config.getMinEvictableIdleTimeMillis());
                    }
                    if (config.getJdbcInterceptors() != null) {
                        this.tomcatJdbcDataSource.getMethod("setJdbcInterceptors", String.class).invoke((Object)this.dataSource, config.getJdbcInterceptors());
                    }
                    if (config.getJmxEnabled() != null) {
                        this.tomcatJdbcDataSource.getMethod("setJmxEnabled", Boolean.TYPE).invoke((Object)this.dataSource, config.getJmxEnabled());
                    }
                    break block17;
                }
                throw new DataSourceException("Unknown class [ org.apache.tomcat.jdbc.pool.DataSource ]");
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new DataSourceException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

